<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpPobierzKwotePodatkuZDecyzjiKP">

        <div class="odpowiedz">
            <xsl:apply-templates />
        </div>

    </xsl:template>

    <xsl:template match="statusZlecenia"/>

    <xsl:template match="kwotaPodatkuZDecyzjiKP">
        <hr/>
        <table>
            <caption>INFORMACJE O PODATKU W ZAKRESIE KARTY PODATKOWEJ USTALONEGO DECYZJĄ</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = '0C'"><td>Udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '3C'"><td>Brak danych w zakresie zapytania</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '6C'"><td>Podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                </xsl:choose>
            </tr>
            <tr>
                <td class="label">Kwota podatku z decyzji</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(kwotaPodatkuZDecyzji, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Liczba miesięcy roku podatkowego za które podatek jest należny</td>
                <td class="opcjonalne"><xsl:value-of select="liczbaMiesiecyDlaKwoty"/></td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>