<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpPobierzKwoteZwrotu">

        <div class="odpowiedz">
            <xsl:apply-templates />
        </div>

    </xsl:template>

    <xsl:template match="kwotaZwrotu">
        <hr/>
        <br/>
        <table>
            <caption>KWOTA Z TYTUŁU NIEWYKORZYSTANEJ ULGI NA DZIECI</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = '0A'"><td colspan="2">Udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '2A'"><td colspan="2">Niezgodność sposobu rozliczenia (wspólne/indywidualne)</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '3A'"><td colspan="2">Brak deklaracji PIT-36 / PIT-37 za podany okres lub w odnalezionych dokumentach nie została wypełniona pozycja dotycząca przysługującej kwoty różnicy</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '4A'"><td colspan="2">Znaleziono niezatwierdzoną deklarację PIT-36/PIT-37, dane nie mogą być zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '5A'"><td colspan="2">Została wydana decyzja wymiarowa do deklaracji PIT-36/PIT-37, dane nie mogą zostać zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '6A'"><td colspan="2">Podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '7A'"><td colspan="2">Wskazany/i w pytaniu podatnik/cy złożył/li więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '9A'"><td colspan="2">Zidentyfikowano osobę i udostępniono dane (przysługująca kwota różnicy tzw. kwota zwrotu z tytułu niewykorzystanej ulgi na dzieci dotyczy obojga rodziców)</td></xsl:when>
                </xsl:choose>
            </tr>
            <tr>
                <td colspan="2">
                    <xsl:apply-templates select="daneOUldze"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="statusZlecenia"/>

    <xsl:template match="daneOUldze">
        <hr/>
        <table>
            <tr>
                <td class="label">Rok podatkowy</td>
                <td colspan='3'><xsl:value-of select="rokPodatkowy"/></td>
            </tr>
            <tr>
                <td class="label">Wartość kwoty zwrotu z tytułu niewykorzystanej ulgi na dzieci</td>
                <td><xsl:value-of select="format-number(kwotaZwrotu, '0,00')"/></td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>