<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times">

    <xsl:template match="/" name="KodpUdostepnienieDanychPesel">

        <xsl:variable name="Obywatelstwo" select="document('../../../../../../../../xml/Obywatelstwo.xml')/properties/entry" />
        <xsl:variable name="WystawcaDokumentu" select="document('../../../../../../../../xml/WystawcaDokumentuPESEL.xml')/properties/entry" />
        <xsl:variable name="RodzajDokumentu" select="document('../../../../../../../../xml/RodzajDokumentuTozsamosciPESEL.xml')/properties/entry" />
        <xsl:variable name="RodzajWymeldowania" select="document('../../../../../../../../xml/RodzajWymeldowaniaPESEL.xml')/properties/entry" />

        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź z usługi</caption>
                <tr>
                    <td class="label">Liczba znalezionych osób</td>
                    <td><xsl:value-of select="//odpowiedzUdostepnianieDanychPesel/liczbaWynikow"/></td>
                </tr>
            </table>
            <xsl:for-each select="//odpowiedzUdostepnianieDanychPesel/daneOsoby">
                <table>
                    <caption>Dane osobowe</caption>
                    <tr>
                        <td class="label">Data aktualizacji</td>
                        <td>
                            <xsl:if test="count(dataAktualizacji)>0">
                                <xsl:value-of select="date:date(dataAktualizacji)"/>
                            </xsl:if>
                        </td>
                        <td class="label">Pesel</td>
                        <td><xsl:value-of select="pesel"/></td>
                    </tr>
                    <tr>
                        <td class="label">Poprzedni pesel</td>
                        <td><xsl:value-of select="poprzedniPesel"/></td>
                        <td class="label">Płeć</td>
                        <td><xsl:value-of select="plec"/></td>
                    </tr>
                    <tr>
                        <td class="label">Obywatelstwo</td>
                        <td>
                            <xsl:variable name="_Obywatelstwo" select="obywatelstwo" />
                            <xsl:value-of select="$Obywatelstwo[@key = $_Obywatelstwo]" />
                        </td>
                        <td class="label">Stan cywilny</td>
                        <td><xsl:value-of select="stanCywilny"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię 1</td>
                        <td><xsl:value-of select="aktualneImionaNazwiska/imie1"/></td>
                        <td class="label">Nazwisko 1</td>
                        <td><xsl:value-of select="aktualneImionaNazwiska/nazwisko1"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię 2</td>
                        <td><xsl:value-of select="aktualneImionaNazwiska/imie2"/></td>
                        <td class="label">Nazwisko 2</td>
                        <td><xsl:value-of select="aktualneImionaNazwiska/nazwisko2"/></td>
                    </tr>
                    <tr>
                        <td class="label">Nazwisko rodowe 1</td>
                        <td><xsl:value-of select="aktualneImionaNazwiska/nazwiskoRodowe1"/></td>
                        <td class="label">Nazwisko rodowe 2</td>
                        <td><xsl:value-of select="aktualneImionaNazwiska/nazwiskoRodowe2"/></td>
                    </tr>
                    <tr>
                        <td class="label">Miejsce urodzenia</td>
                        <td><xsl:value-of select="daneUrodzenia/miejsceUrodzenia"/></td>
                        <td class="label">Data zgonu</td>
                        <td><xsl:value-of select="dataZgonu"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię matki 1</td>
                        <td><xsl:value-of select="daneUrodzenia/imieMatki1"/></td>
                        <td class="label">Nazwisko rodowe matki 1</td>
                        <td><xsl:value-of select="daneUrodzenia/nazwiskoRodoweMatki1"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię matki 2</td>
                        <td><xsl:value-of select="daneUrodzenia/imieMatki2"/></td>
                        <td class="label">Nazwisko rodowe matki 2</td>
                        <td><xsl:value-of select="daneUrodzenia/nazwiskoRodoweMatki2"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię ojca 1</td>
                        <td><xsl:value-of select="daneUrodzenia/imieOjca1"/></td>
                        <td class="label">Nazwisko rodowe ojca 1</td>
                        <td><xsl:value-of select="daneUrodzenia/nazwiskoRodoweOjca1"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię ojca 2</td>
                        <td><xsl:value-of select="daneUrodzenia/imieOjca2"/></td>
                        <td class="label">Nazwisko rodowe ojca 2</td>
                        <td><xsl:value-of select="daneUrodzenia/nazwiskoRodoweOjca2"/></td>
                    </tr>
                </table>

                <xsl:if test="dokument">
                    <table>
                        <caption>Dokumenty tożsamości</caption>
                        <thead>
                            <tr>
                                <th>Data wydania</th>
                                <th>Rodzaj</th>
                                <th>Seria i numer</th>
                                <th>Wystawca dokumentu - kod</th>
                                <th>Wystawca dokumentu</th>
                            </tr>
                        </thead>
                        <xsl:for-each select="dokument">
                            <tr>
                                <td><xsl:value-of select="dataWydania"/></td>
                                <td>
                                    <xsl:variable name="_RodzajDokumentu" select="rodzajDokumentu" />
                                    <xsl:value-of select="$RodzajDokumentu[@key = $_RodzajDokumentu]" />
                                </td>
                                <td><xsl:value-of select="seriaNrDokumentu"/></td>
                                <td><xsl:value-of select="terytWystawcy"/></td>
                                <td>
                                    <xsl:variable name="_WystawcaDokumentu" select="wystawcaDokumentu" />
                                    <xsl:value-of select="$WystawcaDokumentu[@key = $_WystawcaDokumentu]" />
                                </td>
                            </tr>
                        </xsl:for-each>
                    </table>
                </xsl:if>
                <xsl:for-each select="adresZameldowania">
                    <table>
                        <caption>Dane adresowe</caption>
                        <tr>
                            <td class="label">Data zameldowania</td>
                            <td><xsl:value-of select="dataZameldowania"/></td>
                            <td class="label">Data wymeldowania</td>
                            <td><xsl:value-of select="dataWymeldowania"/></td>
                        </tr>
                        <tr>
                            <td class="label">Kod pocztowy</td>
                            <td><xsl:value-of select="kodPocztowy"/></td>
                            <td class="label">Miejscowość</td>
                            <td><xsl:value-of select="miejscowosc"/></td>
                        </tr>
                        <tr>
                            <td class="label">Nr domu</td>
                            <td><xsl:value-of select="nrDomu"/></td>
                            <td class="label">Nr lokalu</td>
                            <td><xsl:value-of select="nrLokalu"/></td>
                        </tr>
                        <tr>
                            <td class="label">Ulica</td>
                            <td><xsl:value-of select="ulica"/></td>
                            <td class="label">Kod teryt</td>
                            <td><xsl:value-of select="kodTeryt"/></td>
                        </tr>
                        <tr>
                            <td class="label">Rodzaj zameldowania</td>
                            <td><xsl:value-of select="rodzajZameldowania"/></td>
                            <td class="label">Rodzaj wymeldowania</td>
                            <td>
                                <xsl:variable name="_RodzajWymeldowania" select="rodzajWymeldowania" />
                                <xsl:value-of select="$RodzajWymeldowania[@key = $_RodzajWymeldowania]" />
                            </td>
                        </tr>
                    </table>
                </xsl:for-each>

            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>

