<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KzadWeryfikacjaOsobyWPesel">

        <div class="odpowiedz">
            <table>
                <caption>Weryfikacja danych z PESEL - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>
                <xsl:if test="count(//kryteriaWymPeselZPorow) > 0">
                    <tr>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//imie1/imie"/>
                        </td>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//nazwisko1/nazwisko"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//dataUrodzenia/data"/>
                        </td>
                        <td class="label">Pesel</td>
                        <td>
                            <xsl:value-of select="//pesel/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nr dokumentu tożsamości</td>
                        <td>
                            <xsl:value-of select="//seriaNrDokumentu/seriaNrDokumnetu"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/miejscowosc/miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Ulica</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/ulica/ulica"/>
                        </td>
                        <td class="label">Nr domu</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/nrDomu/nrBudynku"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteriaWymDaneOsobyZPorow) > 0">
                    <tr>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//imie1"/>
                        </td>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//nazwisko1/nazwisko"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//dataUrodzenia"/>
                        </td>
                        <td class="label">Pesel</td>
                        <td>
                            <xsl:value-of select="//pesel/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nr dokumentu tożsamości</td>
                        <td>
                            <xsl:value-of select="//seriaNrDokumentu/seriaNrDokumnetu"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/miejscowosc/miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Ulica</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/ulica/ulica"/>
                        </td>
                        <td class="label">Nr domu</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/nrDomu/nrBudynku"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteriaWymDokumentZPorow) > 0">
                    <tr>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//imie1/imie"/>
                        </td>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//nazwisko1/nazwisko"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//dataUrodzenia/data"/>
                        </td>
                        <td class="label">Pesel</td>
                        <td>
                            <xsl:value-of select="//pesel/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nr dokumentu tożsamości</td>
                        <td>
                            <xsl:value-of select="//seriaNrDokumentu"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/miejscowosc/miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Ulica</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/ulica/ulica"/>
                        </td>
                        <td class="label">Nr domu</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/nrDomu/nrBudynku"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteriaWymListaPeselZPorow) > 0">
                    <xsl:for-each select="//kryteriaWymListaPeselZPorow/osoba">
                        <tr>
                            <td class="label">PESEL</td>
                            <td><xsl:value-of select="pesel/pesel"/></td>
                        </tr>
                    </xsl:for-each>
                </xsl:if>
            </table>
        </div>
    </xsl:template>
</xsl:stylesheet>