<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns2="http://mpips.gov.pl/xsd/csizs/pi/sg/v1"
                xmlns:date="http://exslt.org/dates-and-times">
    <xsl:template match="/" name="KodpUdostepnienieDanychOsoby">
        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź</caption>
                <tr>
                    <td class="label">Liczba wyników</td>
                    <td><xsl:value-of select="//liczbaWynikow"/></td>
                </tr>
            </table>
            <xsl:for-each select="//daneOsoby">
                <table>
                    <caption>Dane osoby</caption>
                    <xsl:if test="//pesel">
                        <tr>
                            <td class="label">PESEL</td>
                            <td colspan="3"><xsl:value-of select="//pesel"/></td>
                        </tr>
                    </xsl:if>
                    <tr>
                        <td class="label">Nazwisko</td>
                        <td><xsl:value-of select="//nazwisko"/></td>
                        <td class="label">Imię</td>
                        <td><xsl:value-of select="//imie"/></td>
                    </tr>
                    <tr>
                        <td class="label">Numer rejestru *</td>
                        <td><xsl:value-of select="//numerRejestru"/></td>
                        <td class="label">Płeć</td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="//plec = 'M'">MĘŻCZYZNA</xsl:when>
                                <xsl:when test="//plec = 'K'">KOBIETA</xsl:when>
                                <xsl:when test="//plec = 'X'">Nie stosuje się</xsl:when>
                            </xsl:choose>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td><xsl:value-of select="//dataUrodzenia"/></td>
                        <td class="label">Obywatelstwo</td>
                        <td><xsl:value-of select="//obywatelstwo"/></td>
                    </tr>
                    <tr>
                        <td class="label">Rodzaj dokumentu uprawniającego do przekroczenia granicy</td>
                        <td><xsl:value-of select="//rodzajDokumentuPodrozy"/></td>
                        <td class="label">Seria i nr dokumentu</td>
                        <td><xsl:value-of select="//seriaNrDokumentu"/></td>
                    </tr>
                    <tr>
                        <td class="label">Data wjazdu</td>
                        <td><xsl:value-of select="//dataWjazdu"/></td>
                        <td class="label">Data końca uprawnień **</td>
                        <td><xsl:value-of select="//dataKoncaUprawnien"/></td>
                    </tr>
                    <tr>
                        <td class="label">Identyfikator obywatela UA z dokumentu paszportowego</td>
                        <td colspan="3"><xsl:value-of select="//identyfikatorUA"/></td>
                    </tr>

                    <xsl:if test="//dokumentyWykluczajace">
                        <tr>
                            <td colspan="4">
                                <table>
                                    <caption>Dane dokumentu stanowiącego wykluczenie, jeżeli osoba posiada tytuły prawne - dane prezentowane w przypadku występowania decyzji, wniosków i deklaracji o których mowa w art. 2 ust. 3 ustawy o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa</caption>
                                    <xsl:for-each select="//dokumentWykluczajacy">
                                        <tr>
                                            <td class="label" style="width: 15%">Rodzaj dokumentu</td>
                                            <td style="width: 15%"><xsl:value-of select="//rodzajDokumentu"/></td>
                                            <td class="label" style="width: 15%">Seria i nr dokumentu</td>
                                            <td style="width: 15%"><xsl:value-of select="//seriaNrDokumentu"/></td>
                                            <td class="label" style="width: 15%">Data ważności</td>
                                            <td style="width: 15%"><xsl:value-of select="//dataWaznosci"/></td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>

                    </xsl:if>

                </table>
            </xsl:for-each>
            <p style="font-size: 11px">
            *<b>Numer rejestru</b> – numer podawany w przypadku, gdy osoba przekroczyła granicę państwową w związku z konfliktem na terytorium Ukrainy oraz nie podlega wykluczeniu zgodnie z w art. 2 ust. 3 ustawy o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa<br/>
            **<b>Data końca uprawnień</b> - w zakresie  ustawy o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa, data konca uprawnień (data końca uprawnień pobytu w Polsce) jest ustawiana na 24.08.2023  (24.02.2022 + 18 miesięcy), gdy osoba:<br/>
            • przekroczyła granicę państwową w związku z konfliktem na terytorium Ukrainy,<br/>
            • nie posiada tytułów pobytowych (dokumentów wykluczających ujętych w art. 2 ust. 3 ustawy).<br/>
            Dla osoby, która przekroczy granicę, ale posiada dokument wykluczający, data końca uprawnień  nie jest wypełniana.
            W przypadku gdy w/o osoba nabędzie dokument wykluczający, data końca uprawnień ustawiana jest na datę wydania tego dokumentu wykluczającego.
            W przypadku gdy w/o osoba wyjedzie z terytorium RP na okres powyżej jednego miesiąca, data końca uprawnień ustawiana jest na datę wyjazdu z Polski + 1 dzień.
            W przypadku gdy w/o osoba nabędzie tytuł pobytowy a następnie go utraci lub wyjedzie z RP na okres powyżej jednego miesiąca i ponownie przyjedzie do Polski, data końca uprawnień będzie ustawiana na 24.08.2023.
            Element 'data końca uprawnień' zwraca najbardziej aktualne dane z RWiZW, bez danych historycznych.
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>