<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:v1="http://mpips.gov.pl/xsd/csizs/pi/zus/raport/v1"
                xmlns:v4="http://mpips.gov.pl/xsd/csizs/typy/v4"
                xmlns:date="http://exslt.org/dates-and-times">
    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../../css/style.html')/html/head/style"/>
                    .label {
                        text-align: right;
                    }
                </style>
            </head>
            <body>
                <div class="odpowiedz">
                    <table>
                        <caption>Raport zbiorczy z ZUS o osobach pobierających dodatek pielęgnacyjny</caption>
                        <tr>
                            <td class="label">Liczba osób na raporcie</td>
                            <td><xsl:value-of select="count(//osoba)"/></td>
                        </tr>
                        <xsl:for-each select="//v1:raport/osoba">
                            <table>
                                <caption>DANE OSOBY</caption>
                                <tr>
                                    <td class="label">Nazwisko</td>
                                    <td>
                                        <xsl:value-of select="v4:nazwisko"/>
                                    </td>
                                    <td class="label">Imię</td>
                                    <td>
                                        <xsl:value-of select="v4:imie"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="label">PESEL</td>
                                    <td>
                                        <xsl:value-of select="v4:pesel"/>
                                    </td>
                                    <td class="label">Data urodzenia</td>
                                    <td>
                                        <xsl:value-of select="v4:dataUrodzenia"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4">
                                        <table style="width: 60%; margin:auto;">
                                            <caption>Uprawnienia</caption>
                                            <tr>
                                                <th>Data od</th>
                                                <th>Data do</th>
                                            </tr>
                                            <xsl:for-each select="uprawnienia/okres">
                                                <tr>
                                                    <td><xsl:value-of select="dataOd"/></td>
                                                    <td><xsl:value-of select="dataDo"/></td>
                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </xsl:for-each>

                    </table>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>