<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="kodpUdostepnienieDanychODodatkuPielegnacyjnym">
        <div class="odpowiedz">
            <table>
                <caption>Usługa ZUS - odpowiedź - dane o dodatku pielęgnacyjnym</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <td colspan="3">
                        <xsl:choose>
                            <xsl:when test="//status = '00'">Znaleziono osobę i posiada ona okresy uprawnień do dodatku pielęgnacyjnego</xsl:when>
                            <xsl:when test="//status = '01'">Znaleziono osobę – brak danych o okresach uprawnień do dodatku pielęgnacyjnego</xsl:when>
                            <xsl:when test="//status = '02'">Znaleziono osobę – osoba nie żyje</xsl:when>
                            <xsl:when test="//status = '03'">Nie znaleziono osoby (przesłany PESEL jest poprawny pod względem struktury, nie występuje w bazie ZUS podobnie jak pozostałe przesłane dane – osoba, której dotyczą dane nie jest świadczeniobiorcą w ZUS)</xsl:when>
                        </xsl:choose>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <table>
                            <caption>DANE OSOBY</caption>
                            <tr>
                                <td class="label">PESEL</td>
                                <td colspan="3">
                                    <xsl:value-of select="//daneOsoby/pesel"/>
                                </td>
                            </tr>
                            <tr>
                                <td class="label">Nazwisko</td>
                                <td>
                                    <xsl:value-of select="//daneOsoby/nazwisko"/>
                                </td>
                                <td class="label">Imię</td>
                                <td>
                                    <xsl:value-of select="//daneOsoby/imie"/>
                                </td>
                            </tr>
                            <tr>
                                <td class="label">Nr dokumentu</td>
                                <td>
                                    <xsl:value-of select="//daneOsoby/seriaNrDokumentu"/>
                                </td>
                                <td class="label">Nr paszportu</td>
                                <td>
                                    <xsl:value-of select="//daneOsoby/nrPaszportu"/>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <xsl:choose>
                    <xsl:when test="//daneOsoby/uprawnienia">
                        <tr>
                            <td colspan="3">
                                <table>
                                    <caption>UPRAWNIENIA</caption>
                                    <th>Okres od</th>
                                    <th>Okres do</th>
                                    <xsl:for-each select="//daneOsoby/uprawnienia/okres">
                                        <tr>
                                            <td>
                                                <xsl:value-of select="dataOd"/>
                                            </td>
                                            <td>
                                                <xsl:value-of select="dataDo"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </xsl:when>
                    <xsl:otherwise>
                        <tr>
                            <td colspan="3">
                                BRAK INFORMACJI O UPRAWNIENIACH DO DODATKU PIELĘGNACYJNEGO
                            </td>
                        </tr>
                    </xsl:otherwise>
                </xsl:choose>

            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>