<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns2="http://mpips.gov.pl/xsd/csizs/cbb/rb/raport/swn/v1"
                xmlns:ns3="http://mpips.gov.pl/xsd/csizs/typy/v4"
                xmlns:date="http://exslt.org/dates-and-times">
    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../../../css/style.html')/html/head/style"/>
                    .label {
                        text-align: right;
                    }
                </style>
            </head>
            <body>
                <div class="odpowiedz">
                    <table>
                        <caption>Raport zbiorczy o osobach pobierających stare SP, SZO lub ZDO, na które złożono wniosek o świadczenie wspierające</caption>
                        <tr>
                            <td class="label">Liczba osób na raporcie</td>
                            <td><xsl:value-of select="count(//osoba)"/></td>
                        </tr>
                    </table>
                    <xsl:for-each select="//ns2:raport/osoba">
                        <table>
                            <th>
                                OSOBA:
                                <xsl:value-of select="ns3:nazwisko"/><xsl:text> </xsl:text>
                                <xsl:value-of select="ns3:imie"/><xsl:text> </xsl:text>
                                <xsl:text>, </xsl:text><xsl:text>PESEL: </xsl:text><xsl:value-of select="ns3:pesel"/><xsl:text> </xsl:text>
                                <xsl:text>, Data ur: </xsl:text><xsl:value-of select="ns3:dataUrodzenia"/>
                            </th>
                            <xsl:if test="wniosek">
                                <xsl:for-each select="wniosek">
                                    <tr>
                                        <td>
                                            <table style="width: 90%; margin: auto;">
                                                <caption>Wniosek</caption>
                                                <tr>
                                                    <td class="label">Data wpłynięcia</td>
                                                    <td><xsl:value-of select="date:formatDate(dataWplynieciaWniosku, 'yyyy-MM-dd')"/></td>
                                                    <td class="label">Data zamknięcia sprawy</td>
                                                    <td><xsl:value-of select="dataZamknieciaSprawy"/></td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Rodzaj wnioskodawcy</td>
                                                    <td><xsl:value-of select="rodzajWnioskodawcy/ns3:wartosc"/></td>
                                                    <td class="label">Rodzaj wniosku</td>
                                                    <td><xsl:value-of select="rodzajWniosku/ns3:wartosc"/></td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Status wniosku</td>
                                                    <td><xsl:value-of select="statusWniosku/ns3:wartosc"/></td>
                                                    <td class="label">Okres</td>
                                                    <td><xsl:value-of select="okres"/></td>
                                                </tr>
                                                <xsl:if test="decyzja">
                                                    <xsl:for-each select="decyzja">
                                                        <tr>
                                                            <td colspan="4">
                                                                <table style="width: 95%; margin: auto;">
                                                                    <caption>Decyzja</caption>
                                                                    <tr>
                                                                        <td class="label">Data podjęcia</td>
                                                                        <td><xsl:value-of select="dataPodjeciaDecyzji"/></td>
                                                                        <td class="label">Data uprawomocnienia</td>
                                                                        <td><xsl:value-of select="dataUprawomocnienia"/></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="label">Rodzaj decyzji</td>
                                                                        <td><xsl:value-of select="rodzajDecyzji/ns3:wartosc"/></td>
                                                                        <td class="label">Instancja decyzji</td>
                                                                        <td><xsl:value-of select="instancjaDecyzji/ns3:wartosc"/></td>
                                                                    </tr>
                                                                    <xsl:if test="swiadczenie">
                                                                        <xsl:for-each select="swiadczenie">
                                                                            <tr>
                                                                                <td colspan="4">
                                                                                    <table style="width: 95%; margin: auto;">
                                                                                        <caption>Świadczenie</caption>
                                                                                        <tr>
                                                                                            <td class="label">Czy dotyczy rodziny</td>
                                                                                            <td>
                                                                                                <xsl:choose>
                                                                                                    <xsl:when test="czyDotyczyRodziny = 'true'">TAK</xsl:when>
                                                                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                                                                </xsl:choose>
                                                                                            </td>
                                                                                            <td class="label">Okres świadczeniowy</td>
                                                                                            <td><xsl:value-of select="okresSwiadczeniowy/ns3:wartosc"/></td>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <td class="label">Rodzaj świadczenia</td>
                                                                                            <td><xsl:value-of select="rodzajSwiadczenia/ns3:wartosc"/></td>
                                                                                            <td class="label">Status świadczenia</td>
                                                                                            <td><xsl:value-of select="statusSwiadczenia/ns3:wartosc"/></td>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <td class="label">Data początku</td>
                                                                                            <td><xsl:value-of select="dataPoczatku"/></td>
                                                                                            <td class="label">Data końca</td>
                                                                                            <td><xsl:value-of select="dataZakonczenia"/></td>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <td class="label">Wartość</td>
                                                                                            <td><xsl:value-of select="wartoscSwiadczenia/wartosc"/></td>
                                                                                        </tr>
                                                                                    </table>
                                                                                </td>
                                                                            </tr>
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </xsl:for-each>
                                                </xsl:if>
                                            </table>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </xsl:if>
                        </table>
                    </xsl:for-each>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
