<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns4="http://mpips.gov.pl/xsd/csizs/cbb/rb/v4"
                xmlns:ns3="http://mpips.gov.pl/xsd/csizs/typy/v4">
    <xsl:template match="/" name="kOdpWeryfWystepowaniaOsCBB">

        <div class="odpowiedz">
            <table>
                <caption>Weryfikacja występowania osoby w CBB</caption>
                <tr>
                    <th colspan="2">Osoba występuje w CBB z identyfikatorem idTozsamosciCBB:</th>
                    <td colspan="2">
                        <xsl:value-of select="//daneOsoby/idTozsamosciCBB"/>
                    </td>
                </tr>
                <tr>
                    <th>Nazwisko</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/nazwisko"/>
                    </td>
                    <th>Imię</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/imie"/>
                    </td>
                </tr>
            </table>
            <table>
                <caption>Ostatni adres osoby</caption>
                <tr>
                    <th>Miejscowość</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/ostatniAdres/dane/miejscowosc"/>
                    </td>
                    <th>Kod pocztowy</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/ostatniAdres/dane/kodPocztowy"/>
                    </td>
                </tr>
                <tr>
                    <th>Ulica</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/ostatniAdres/dane/ulica"/>
                    </td>
                    <th>Nr domu</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/ostatniAdres/dane/nrDomu"/>
                    </td>
                </tr>
                <tr>
                    <th>Nr lokalu</th>
                    <td>
                        <xsl:value-of select="//daneOsoby/ostatniAdres/dane/nrLokalu"/>
                    </td>
                </tr>
            </table>
            <xsl:if test="//daneOsoby/ostatniDokumentTozsamosci">
                <table>
                    <caption>Ostatni dokument tożsamości</caption>
                    <tr>
                        <td class="label">Nr dokumentu</td>
                        <td>
                            <xsl:value-of select="//daneOsoby/ostatniDokumentTozsamosci/wyroznik/seriaNumer"/>
                        </td>
                        <td class="label">Rodzaj dokumentu</td>
                        <td>
                            <xsl:value-of select="//daneOsoby/ostatniDokumentTozsamosci/wyroznik/rodzajDokumentu/ns3:wartosc"/>
                        </td>
                    </tr>
                </table>
            </xsl:if>
        </div>

    </xsl:template>
</xsl:stylesheet>

