<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times">
    <xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

    <xsl:template match="/" name="kodpUdostepnianieDanychAC">

        <div class="odpowiedz">
            <xsl:if test="//daneOsoby">
                <div style="font-weight: bold; color: green;">
                    Znaleziono osobę wg podanych kryteriów
                </div>
            </xsl:if>
            <xsl:for-each select="//statusOsoby">
                <table>
                    <caption>Status osoby</caption>
                    <tr>
                        <td class="label">Kod statusu</td>
                        <td><xsl:value-of select="kodStatusu"/></td>
                        <td class="label">Nazwa statusu</td>
                        <td><xsl:value-of select="nazwaStatusu"/></td>
                    </tr>
                    <tr>
                        <td class="label">Kod</td>
                        <td><xsl:value-of select="zrodlo/kod"/></td>
                        <td class="label">Opis</td>
                        <td><xsl:value-of select="zrodlo/opis"/></td>
                    </tr>
                </table>

            </xsl:for-each>
            <xsl:for-each select="//stazPracy">
                <table>
                    <caption>Staż pracy</caption>
                    <tr>
                        <td class="label">Liczba lat</td>
                        <td><xsl:value-of select="staz/liczbaLat"/></td>
                        <td class="label">Liczba miesięcy</td>
                        <td><xsl:value-of select="staz/liczbaMiesiecy"/></td>
                    </tr>
                    <tr>
                        <td class="label">Liczba dni</td>
                        <td colspan='3'><xsl:value-of select="staz/liczbaDni"/></td>
                    </tr>
                    <tr>
                        <td class="label">Kod placówki UP</td>
                        <td><xsl:value-of select="zrodlo/kod"/></td>
                        <td class="label">Opis placówki UP</td>
                        <td><xsl:value-of select="zrodlo/opis"/></td>
                    </tr>
                </table>
            </xsl:for-each>
            <xsl:for-each select="//uslugiRynkuPracy">
                <table>
                    <caption>Usługa rynku pracy</caption>
                    <tr>
                        <td class="label">Rodzaj usługi</td>
                        <td colspan='3'><xsl:value-of select="rodzajUslugi"/></td>
                    </tr>
                    <tr>
                        <td class="label">Okres od:</td>
                        <td><xsl:value-of select="date:formatDate(okres/dataOd, 'yyyy-MM-dd')"/></td>
                        <td class="label">Okres do:</td>
                        <td><xsl:value-of select="date:formatDate(okres/dataDo, 'yyyy-MM-dd')"/></td>
                    </tr>
                    <tr>
                        <td class="label">Status</td>
                        <td><xsl:value-of select="status"/></td>
                        <td class="label">Opis</td>
                        <td><xsl:value-of select="opis"/></td>
                    </tr>
                    <tr>
                        <td class="label">Kod placówki UP</td>
                        <td><xsl:value-of select="zrodlo/kod"/></td>
                        <td class="label">Opis placówki UP</td>
                        <td><xsl:value-of select="zrodlo/opis"/></td>
                    </tr>
                </table>

            </xsl:for-each>
            <xsl:for-each select="//skladkiUbezpZdr">
                <table>
                    <caption>Składka ubezp.zdr.</caption>
                    <tr>
                        <td class="label">Czy wypłacona</td>
                        <td colspan='3'>
                            <xsl:choose>
                                <xsl:when test="czySkladkaWyplacona = 'true'">TAK</xsl:when>
                                <xsl:otherwise>NIE</xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Okres od:</td>
                        <td><xsl:value-of select="date:formatDate(okresRozliczeniowy/dataOd, 'yyyy-MM-dd')"/></td>
                        <td class="label">Okres do:</td>
                        <td><xsl:value-of select="date:formatDate(okresRozliczeniowy/dataDo, 'yyyy-MM-dd')"/></td>
                    </tr>
                    <tr>
                        <td class="label">Kod placówki UP</td>
                        <td><xsl:value-of select="zrodlo/kod"/></td>
                        <td class="label">Opis placówki UP</td>
                        <td><xsl:value-of select="zrodlo/opis"/></td>
                    </tr>
                </table>
            </xsl:for-each>
            <xsl:for-each select="//zasilki">
                <table>
                    <caption>Zasiłek</caption>
                    <tr>
                        <td class="label">Status</td>
                        <td colspan='3'><xsl:value-of select="status"/></td>
                    </tr>
                    <tr>
                        <td class="label">Rodzaj zasiłku</td>
                        <td><xsl:value-of select="rodzajZasilku"/></td>
                        <td class="label">Opis</td>
                        <td><xsl:value-of select="opis"/></td>
                    </tr>
                    <tr>
                        <td class="label">Kwota brutto</td>
                        <td><xsl:value-of select="format-number(kwotaBrutto, '0,00')"/></td>
                        <td class="label">Data wypłaty</td>
                        <td><xsl:value-of select="date:formatDate(dataWyplaty, 'yyyy-MM-dd')" /></td>
                    </tr>
                    <tr>
                        <td class="label">Okres od:</td>
                        <td><xsl:value-of select="date:formatDate(okresObowiazywania/dataOd, 'yyyy-MM-dd')"/></td>
                        <td class="label">Okres do:</td>
                        <td><xsl:value-of select="date:formatDate(okresObowiazywania/dataDo, 'yyyy-MM-dd')" /></td>
                    </tr>
                    <tr>
                        <td class="label">Kod placówki UP</td>
                        <td><xsl:value-of select="zrodlo/kod"/></td>
                        <td class="label">Opis placówki UP</td>
                        <td><xsl:value-of select="zrodlo/opis"/></td>
                    </tr>
                </table>
            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>