<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/" name="KodpUdostepnienieDanychOrzeczeniaPS">

        <xsl:variable name="StatusOdpowiedzi" select="document('../../../../../../../../xml/StatusOdpowiedziEksmoon.xml')/properties/entry" />
        <xsl:variable name="RodzajOrzeczenia" select="document('../../../../../../../../xml/RodzajOrzeczeniaEksmoon.xml')/properties/entry" />

        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź</caption>
                <tr>
                    <td class="label" colspan="2">Status odpowiedzi</td>
                    <td colspan="2">
                        <xsl:variable name="_Status" select="//statusOdpowiedzi" />
                        <xsl:value-of select="$StatusOdpowiedzi[@key = $_Status]" />
                    </td>
                </tr>
                <xsl:if test="//wynikiUdostepnieniaPS">
                    <tr>
                        <td class="label">Stopień niepełnosprawności</td>
                        <td><xsl:value-of select="//orzeczenie/stopienNiepelnosprawnosci"/></td>
                        <td class="label">Data niepełnosprawności</td>
                        <td><xsl:value-of select="//orzeczenie/dataNiepelnosprawnosci"/></td>
                    </tr>
                    <tr>
                        <td class="label">Nr orzeczenia</td>
                        <td><xsl:value-of select="//orzeczenie/nrOrzeczenia"/></td>
                        <td class="label">Data wydania orzeczenia</td>
                        <td><xsl:value-of select="//orzeczenie/dataWydaniaOrzeczenia"/></td>
                    </tr>
                    <tr>
                        <td class="label">Okres ważności orzeczenia</td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="//orzeczenie/okresWaznosciOrzeczenia = '9999-01-01'">bezterminowe</xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="//orzeczenie/okresWaznosciOrzeczenia"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td class="label">Data złożenia wniosku</td>
                        <td><xsl:value-of select="//orzeczenie/dataZlozeniaWniosku"/></td>
                    </tr>
                    <tr>
                        <td class="label">Rodzaj orzeczenia</td>
                        <td>
                            <xsl:variable name="_RodzajOrzeczenia" select="//orzeczenie/kodSLRodzajOrzeczenia" />
                            <xsl:value-of select="$RodzajOrzeczenia[@key = $_RodzajOrzeczenia]" />
                        </td>
                        <td class="label">Wskazania na orzeczeniu</td>
                        <td>
                            <xsl:for-each select="//orzeczenie/kodSLWskazaniaNaOrzeczeniu">
                                <xsl:value-of select="."/>
                                <xsl:if test='position() != last()'><br/></xsl:if>
                            </xsl:for-each>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>