<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times">

    <xsl:template match="/" name="kodpUdostepnianieDanychZKRS">

        <div class="odpowiedz">
            <table>
                <tr>
                    <td class="label">Limit przekroczony</td>
                    <td colspan='3'>
                        <xsl:choose>
                            <xsl:when test="//limitPrzekroczony = 'true'">TAK</xsl:when>
                            <xsl:otherwise>NIE</xsl:otherwise>
                        </xsl:choose>
                    </td>
                </tr>
            </table>
            <xsl:if test="count(//podmioty) = 0">
                <div style="font-weight: bold; color: green;">BRAK DANYCH WG PODANYCH KRYTERIÓW</div>
            </xsl:if>
            <xsl:for-each select="//podmioty">
                <table>
                    <tr>
                        <td class="label">Nazwa podmiotu</td>
                        <td><xsl:value-of select="nazwaPodmiotu"/></td>
                        <td class="label">NIP</td>
                        <td><xsl:value-of select="nip"/></td>
                    </tr>
                    <tr>
                        <td class="label">Numer KRS</td>
                        <td><xsl:value-of select="numerKRS"/></td>
                        <td class="label">Regon</td>
                        <td><xsl:value-of select="regon"/></td>
                    </tr>
                    <tr>
                        <td class="label">Zawieszenie działalności</td>
                        <td><xsl:value-of select="date:formatDate(dataZawieszeniaDzialalnosci, 'yyyy-MM-dd')"/></td>
                        <td class="label">Forma prawna</td>
                        <td><xsl:value-of select="formaPrawna"/></td>
                    </tr>
                    <tr>
                        <td class="label">Rejestr</td>
                        <td><xsl:value-of select="rejestr"/></td>
                        <td class="label">Czy OPP</td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="czyOPP = 'true'">TAK</xsl:when>
                                <xsl:otherwise>NIE</xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data wznowienia działalności</td>
                        <td><xsl:value-of select="date:formatDate(dataWznowieniaDzialalnosci, 'yyyy-MM-dd')"/></td>
                        <td class="label">Data wykreślenia z rejestru</td>
                        <td><xsl:value-of select="date:formatDate(dataWykresleniaZRejestru, 'yyyy-MM-dd')"/></td>
                    </tr>
                    <tr>
                        <td class="label">Data wpisu do rejestru</td>
                        <td><xsl:value-of select="date:formatDate(dataWpisuDoRejestru, 'yyyy-MM-dd')"/></td>
                        <td class="label">Data uprawomocnienia wykreślenia</td>
                        <td><xsl:value-of select="date:formatDate(dataUprawomocnieniaWykreslenia, 'yyyy-MM-dd')"/></td>
                    </tr>
                    <tr>
                        <td class="label">Data przyznania OPP</td>
                        <td colspan="3"><xsl:value-of select="date:formatDate(dataPrzyznaniaStatusuOPP, 'yyyy-MM-dd')"/></td>
                    </tr>
                    <tr>
                        <td class="label">Miejscowość</td>
                        <td><xsl:value-of select="daneAdresowe/miejscowosc"/></td>
                        <td class="label">Kod pocztowy</td>
                        <td><xsl:value-of select="daneAdresowe/kodPocztowy"/></td>
                    </tr>
                    <tr>
                        <td class="label">Adres</td>
                        <td><xsl:value-of select="daneAdresowe/adres"/></td>
                        <td class="label">Gmina</td>
                        <td><xsl:value-of select="daneAdresowe/gmina"/></td>
                    </tr>
                    <tr>
                        <td class="label">Powiat</td>
                        <td><xsl:value-of select="daneAdresowe/powiat"/></td>
                        <td class="label">Województwo</td>
                        <td><xsl:value-of select="daneAdresowe/wojewodztwo"/></td>
                    </tr>
                    <tr>
                        <td class="label">Czy w upadłości</td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="daneOUpdalosci/czyWUpadlosci = 'true'">TAK</xsl:when>
                                <xsl:otherwise>NIE</xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                </table>
            </xsl:for-each>
        </div>

    </xsl:template>
</xsl:stylesheet>