<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="kzadUdostepnianieDanychZKRS">

        <div class="odpowiedz">
            <table>
                <caption>Udostępnienie danych z KRS - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>
                <xsl:if test="count(//numerKRS) > 0">
                    <tr>
                        <td class="label">Numer KRS</td>
                        <td colspan="3">
                            <xsl:value-of select="//numerKRS"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteria/kryteria) > 0">
                    <tr>
                        <td class="label">Gmina</td>
                        <td>
                            <xsl:value-of select="//gmina"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nazwa</td>
                        <td>
                            <xsl:value-of select="//nazwa"/>
                        </td>
                        <td class="label">NIP</td>
                        <td>
                            <xsl:value-of select="//nip"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Powiat</td>
                        <td>
                            <xsl:value-of select="//powiat"/>
                        </td>
                        <td class="label">REGON</td>
                        <td>
                            <xsl:value-of select="//regon"/>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>