<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="kodpPobierzDodatekPielegnacyjny">
        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź - dane o dodatku pielęgnacyjnym</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <td colspan="2">
                        <xsl:choose>
                            <xsl:when test="//statusOdpowiedzi = 'NIEPOPRAWNE_DANE_OPERACJI'">Niepoprawne dane w kryteriach wyszukiwania</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'OSOBA_ZNALEZIONA_SA_DANE'">Osoba została znaleziona, pobrano dane</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'OSOBA_NIE_ZOSTALA_ZNALEZIONA'">Osoba nie została znaleziona lub znaleziona osoba nie spełnia innych warunków np.: nie jest płatnikiem we wskazanym okresie</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'ZNALEZIONO_WIELE_OSOB'">Wg podanych kryteriów znaleziono wiele osób, konieczne doprecyzowanie kryteriów lub kontakt z pracownikiem KRUS</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'OSOBA_JEST_PLATNIKIEM_Z_INNA_PODSTAWA'">Osoba jest płatnikiem z inną podstawą prawną. Status dotyczy tylko osób, które są rolnikami i podlegają ubezpieczeniu zdrowotnemu z tego tytułu (niezależnie od tego czy sami opłacają składki czy budżet państwa je płaci), i jednocześnie nie są emerytami/rencistami rolniczymi i nie prowadzą działów specjalnych produkcji rolnej w zadanym okresie.</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'ZLECENIE_W_TRAKCIE_REALIZACJI'">Dane nie zostały jeszcze przygotowane</xsl:when>
                        </xsl:choose>
                    </td>
                </tr>
                <xsl:if test="//osoba">
                    <table>
                        <caption><b>OSOBA</b></caption>
                        <tr>
                            <td class="label">Nazwisko</td>
                            <td><xsl:value-of select="//osoba/nazwisko"/></td>
                            <td class="label">Imiona</td>
                            <td><xsl:value-of select="//osoba/imiona"/></td>
                        </tr>
                        <tr>
                            <td class="label">PESEL</td>
                            <td><xsl:value-of select="//osoba/pesel"/></td>
                            <td class="label">Data urodzenia</td>
                            <td><xsl:value-of select="//osoba/dataUrodzenia"/></td>
                        </tr>

                        <xsl:choose>
                            <xsl:when test="//dodatek/czyPobieraDodatek = 'true'">
                                <tr>
                                    <td class="label">Osoba pobiera dodatek - data nabycia uprawnień: </td>
                                    <td colspan="3">
                                        <xsl:value-of select="//dodatek/dataNabyciaUprawnien"/>
                                    </td>
                                </tr>
                            </xsl:when>
                            <xsl:otherwise>
                                <tr>
                                    <td colspan="4">OSOBA NIE POBIERA DODATKU PIELĘGNACYJNEGO</td>
                                </tr>
                            </xsl:otherwise>
                        </xsl:choose>
                    </table>
                </xsl:if>
            </table>
        </div>
    </xsl:template>
</xsl:stylesheet>