<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:v1="http://mpips.gov.pl/xsd/csizs/pi/krus/v1"
                xmlns:v4="http://mpips.gov.pl/xsd/csizs/typy/v4"
                xmlns:date="http://exslt.org/dates-and-times">
    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../css/style.html')/html/head/style"/>
                    .label {
                        text-align: right;
                    }
                </style>
            </head>
            <body>
                <div class="odpowiedz">
                    <table>
                        <caption>Raport zbiorczy z KRUS o osobach pobierających dodatek pielęgnacyjny</caption>
                        <tr>
                            <td class="label">Liczba osób na raporcie</td>
                            <td><xsl:value-of select="count(//osoba)"/></td>
                        </tr>
                    </table>
                    <xsl:for-each select="//v1:raport/osoba">
                        <table>
                            <caption><b>OSOBA</b></caption>
                            <tr>
                                <td class="label">Nazwisko</td>
                                <td><xsl:value-of select="v4:nazwisko"/></td>
                                <td class="label">Imię</td>
                                <td><xsl:value-of select="v4:imie"/></td>
                            </tr>
                            <tr>
                                <td class="label">PESEL</td>
                                <td><xsl:value-of select="v4:pesel"/></td>
                                <td class="label">Data urodzenia</td>
                                <td><xsl:value-of select="v4:dataUrodzenia"/></td>
                            </tr>
                            <xsl:choose>
                                <xsl:when test="dodatek/czyPobieraDodatek = 'true'">
                                    <tr>
                                        <td class="label">Osoba pobiera dodatek - data nabycia uprawnień: </td>
                                        <td colspan="3">
                                            <xsl:value-of select="dodatek/dataNabyciaUprawnien"/>
                                        </td>
                                    </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                    <tr>
                                        <td colspan="4">OSOBA NIE POBIERA DODATKU PIELĘGNACYJNEGO</td>
                                    </tr>
                                </xsl:otherwise>
                            </xsl:choose>
                        </table>
                    </xsl:for-each>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>