<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns="http://mpips.gov.pl/xsd/csizs/pi/men/uczniowie/v1"
                xmlns:date="http://exslt.org/dates-and-times">

    <xsl:template match="/" name="KodpUczniowieHistoria">

        <div class="odpowiedz">
            <xsl:call-template name="daneOsoby"/>

            <xsl:if test="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria[ns:statusUcznia='0']">
                <table>
                    <tr>
                        <td class="label">Status</td>
                        <td>nie znaleziono osoby w badanym okresie w bazie SIO MEN</td>
                    </tr>
                    <tr>
                        <td class="label">Termin weryfikacji</td>
                        <td><xsl:value-of select="date:formatDate(//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:terminWeryfikacji, 'yyyy-MM-dd')" /></td>
                    </tr>
                </table>
            </xsl:if>

            <xsl:if test="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria[ns:statusUcznia='1']">
                <table>
                    <caption>Wskazana wyżej osoba była uczniem w:</caption>
                    <tr>
                        <td>
                            <xsl:for-each select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria[ns:statusUcznia='1']">
                                <xsl:call-template name="historia"/>
                            </xsl:for-each>
                        </td>
                    </tr>
                </table>
            </xsl:if>

            <xsl:if test="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria[ns:statusUcznia='2']">
                <table>
                    <caption>Wskazana wyżej osoba była przypisana do szkoły jednak nie była przypisana do oddziału w:</caption>
                    <tr>
                        <td>
                            <xsl:for-each select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria[ns:statusUcznia='2']">
                                <xsl:call-template name="historia"/>
                            </xsl:for-each>
                        </td>
                    </tr>
                </table>
            </xsl:if>

            <xsl:if test="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria[ns:statusUcznia='3']">
                <table>
                    <tr>
                        <td class="label">Status</td>
                        <td>Znaleziono wiele osób o imieniu i nazwisku:
                            <xsl:value-of select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:imie"/>&#160;
                            <xsl:value-of select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:nazwisko"/>
                            , lecz o różnych numerach identyfikacyjnych</td>
                    </tr>
                    <tr>
                        <td class="label">Termin weryfikacji</td>
                        <td><xsl:value-of select="date:formatDate(//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:terminWeryfikacji, 'yyyy-MM-dd')" /></td>
                    </tr>
                </table>
            </xsl:if>
        </div>

    </xsl:template>

    <xsl:template name="historia">
        <table>
            <tr>
                <td colspan="4">
                    <xsl:if test="ns:danePodmiotu/ns:nazwaPodmiotu">
                       <xsl:call-template name="daneSzkoly"/>
                    </xsl:if>
                    <table>
                        <caption>Status ucznia</caption>
                        <td class="label">Status osoby</td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="ns:statusUcznia = 0">nie uczeń</xsl:when>
                                <xsl:when test="ns:statusUcznia = 1">uczeń</xsl:when>
                                <xsl:when test="ns:statusUcznia = 2">nie przypisano do oddziału</xsl:when>
                                <xsl:when test="ns:statusUcznia = 3">wiele osób spełniających kryterium</xsl:when>
                            </xsl:choose>
                        </td>
                        <td class="label">Termin weryfikacji</td>
                        <td><xsl:value-of select="date:formatDate(ns:terminWeryfikacji, 'yyyy-MM-dd')" /></td>
                    </table>
                    <xsl:if test="ns:okres/ns:dataRozpoczecia">
                        <table>
                            <caption>Okres nauki</caption>
                            <tr>
                                <td class="label">Data rozpoczęcia nauki</td>
                                <td><xsl:value-of select="date:formatDate(ns:okres/ns:dataRozpoczecia, 'yyyy-MM-dd')" /></td>
                                <td class="label">Data zakończenia nauki</td>
                                <td>
                                    <xsl:choose>
                                        <xsl:when test="date:formatDate(ns:okres/ns:dataZakonczenia, 'yyyy-MM-dd') = '9999-12-31'">
                                            do dnia dokonania weryfikacji
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="date:formatDate(ns:okres/ns:dataZakonczenia, 'yyyy-MM-dd')" />
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </td>
                            </tr>
                            <tr>
                                <td class="label">Klasa</td>
                                <td colspan="3">
                                    <xsl:choose>
                                        <xsl:when test="ns:klasa">
                                            <xsl:value-of select="ns:klasa"/>
                                        </xsl:when>
                                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                                    </xsl:choose>
                                </td>
                            </tr>
                        </table>
                    </xsl:if>
                </td>
            </tr>
        </table>
    </xsl:template>

    <!-- element dla danych osoby - drukowany tylko raz-->
    <xsl:template name="daneOsoby">
        <table>
            <caption>Dane osobowe</caption>
            <tr>
                <td class="label">Nazwisko</td>
                <td><xsl:value-of select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:nazwisko"/></td>
                <td class="label">Imię</td>
                <td><xsl:value-of select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:imie"/></td>
            </tr>
            <tr>
                <td class="label">PESEL</td>
                <td><xsl:value-of select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:nrPesel"/></td>
                <td class="label">Data urodzenia</td>
                <td><xsl:value-of select="date:formatDate(//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:dataUrodzenia, 'yyyy-MM-dd')" /></td>
            </tr>
            <xsl:if test="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:nrDokumentu">
                <tr>
                    <td class="label">Numer dokumentu</td>
                    <td colspan="3"><xsl:value-of select="//ns:KodpUczniowieHistoria/ns:uczenStatusHistoria/ns:daneOsoby/ns:nrDokumentu"/></td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>

    <xsl:template name="daneSzkoly">
        <table>
            <caption>Dane szkoły</caption>
            <tr>
                <td class="label">Typ podmiotu</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="ns:danePodmiotu/ns:typPodmiotu">
                            <xsl:value-of select="ns:danePodmiotu/ns:typPodmiotu"/>
                        </xsl:when>
                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                    </xsl:choose>
                </td>
                <td class="label">Nazwa</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="ns:danePodmiotu/ns:nazwaPodmiotu">
                            <xsl:value-of select="ns:danePodmiotu/ns:nazwaPodmiotu"/>
                        </xsl:when>
                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td class="label">Miejscowość</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="ns:danePodmiotu/ns:miejscowosc">
                            <xsl:value-of select="ns:danePodmiotu/ns:miejscowosc"/>
                        </xsl:when>
                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                    </xsl:choose>
                </td>
                <td class="label">Gmina</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="ns:danePodmiotu/ns:gmina">
                            <xsl:value-of select="ns:danePodmiotu/ns:gmina"/>
                        </xsl:when>
                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td class="label">Powiat</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="ns:danePodmiotu/ns:powiat">
                            <xsl:value-of select="ns:danePodmiotu/ns:powiat"/>
                        </xsl:when>
                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                    </xsl:choose>
                </td>
                <td class="label">Województwo</td>
                <td>
                    <xsl:choose>
                        <xsl:when test="ns:danePodmiotu/ns:wojewodztwo">
                            <xsl:value-of select="ns:danePodmiotu/ns:wojewodztwo"/>
                        </xsl:when>
                        <xsl:otherwise>brak danych w bazie SIO MEN</xsl:otherwise>
                    </xsl:choose>
                </td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>
