<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns2="http://mpips.gov.pl/xsd/csizs/pi/men/uczniowie/v1">

    <xsl:template match="/" name="KzadUczniowieHistoria">

        <div class="odpowiedz">
            <table>
                <caption>Usługa MEN - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td>
                        <xsl:value-of select="//ns2:kontekst/nrSprawy"/>
                    </td>
                </tr>
                <xsl:if test="//ns2:nrPesel">
                    <tr>
                        <td class="label">PESEL</td>
                        <td>
                            <xsl:value-of select="//ns2:nrPesel"/>
                        </td>
                    </tr>
                </xsl:if>
                <tr>
                    <td class="label">Nazwisko</td>
                    <td>
                        <xsl:value-of select="//ns2:nazwisko"/>
                    </td>
                </tr>
                <tr>
                    <td class="label">Imię</td>
                    <td>
                        <xsl:value-of select="//ns2:imie"/>
                    </td>
                </tr>
                <xsl:if test="//ns2:dataUrodzenia">
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//ns2:dataUrodzenia"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="//ns2:nrDokumentu">
                <tr>
                    <td class="label">Nr dokumentu tożsamości</td>
                    <td>
                        <xsl:value-of select="//ns2:nrDokumentu"/>
                    </td>
                </tr>
                </xsl:if>
                <tr>
                    <td class="label">Data rozpoczęcia</td>
                    <td>
                        <xsl:value-of select="//ns2:dataRozpoczecia"/>
                    </td>
                </tr>
                <tr>
                    <td class="label">Data zakończenia</td>
                    <td>
                        <xsl:value-of select="//ns2:dataZakonczenia"/>
                    </td>
                </tr>
            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>