<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpUdostepnienieDanychODochodach">

        <div class="odpowiedz">
            <table>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <xsl:choose>
                        <xsl:when test="//statusOdpowiedzi = 0"><td>zidentyfikowano osoby i udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 1"><td>nie znaleziono osób</td><td>Zweryfikuj w  rejestrze  PESEL i sprawdź, czy dane (nr PESEL, Imię pierwsze, Nazwisko) są zgodne - jeśli są zgodne, to należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 2"><td>niezgodność wspólnego rozliczenia (wspólnie/indywidualnie)</td><td>Komunikat wystąpi, jeśli zapytanie jest na podatnika a zeznanie złożono  wspólnie z małżonkiem bądź, jeśli zapytanie jest jednocześnie na podatnika i małżonka a podatnicy rozliczyli się osobno</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 3"><td>brak deklaracji podatkowych za podany okres</td><td>Podatnik nie złożył zeznania PIT</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 4"><td>znaleziono niezatwierdzoną deklarację, dane nie mogą być zwrócone</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 5"><td>została wydana decyzja wymiarowa, dane nie mogą być zwrócone</td><td>Nie można wydzielić kwoty dochodu - należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 6"><td>podany w zapytaniu rok nie jest obsługiwany przez usługę</td><td>Dane za rok poprzedni będą dostępne od sierpnia bieżącego roku</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 7"><td>wskazany w pytaniu podatnik złożył więcej deklaracji tego samego typu w jednym okresie</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 8"><td>limit dochodu został przekroczony, wyślij zapytanie specjalne by uzyskać informacje</td><td>Dane można uzyskać poprzez wykonanie zapytania specjalnego</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 9"><td>zidentyfikowano osobę i udostępniono dane </td><td>Dla PIT-36 oraz PIT-37 kwota podatku należnego została obliczona od sumy dochodów obojga podatników, natomiast pozostałe pozycje dotyczą jedynie podatnika, którego dotyczyło zapytanie</td></xsl:when>
                    </xsl:choose>
                </tr>
            </table>
            <xsl:if test="//odpowiedzUdostepnianieDanychODochodach">
                <table>
                    <tr>
                        <td class="label">Rok podatkowy</td>
                        <td colspan='3'><xsl:value-of select="//rokPodatkowy"/></td>
                    </tr>
                </table>
                <!-- osoba 1 -->
                <table>
                    <tr>
                        <td colspan='4' align="center">DANE OSOBY 1</td>
                    </tr>
                    <tr>
                        <td class="label">PESEL</td>
                        <td colspan='3'><xsl:value-of select="//osoba1/pesel"/></td>
                    </tr>
                    <tr>
                        <td colspan="4">
                            <xsl:for-each select="//osoba1/PIT">
                                <table>
                                    <tr>
                                        <td class="label">Typ PIT</td>
                                        <td colspan='3'><xsl:value-of select="@typ"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Dochód</td>
                                        <td><xsl:value-of select="format-number(dochod, '0,00')"/></td>
                                        <td class="label">Dochód małoletnich dzieci</td>
                                        <td><xsl:value-of select="format-number(dochodDzieci, '0,00')"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Składka na ubezpieczenie społeczne</td>
                                        <td><xsl:value-of select="format-number(skladkaUbezpSpol, '0,00')"/></td>
                                        <td class="label">Podatek należny od dochodu</td>
                                        <td><xsl:value-of select="format-number(naleznyPodatek, '0,00')"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Dochody osiągnięte za granicą</td>
                                        <td><xsl:value-of select="format-number(dochodyOsiagnieteZaGranica, '0,00')"/></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Czy wspólne</td>
                                        <td>
                                            <xsl:choose>
                                                <xsl:when test="czyWspolne = 'true'">TAK</xsl:when>
                                                <xsl:otherwise>NIE</xsl:otherwise>
                                            </xsl:choose></td>
                                        <td class="label">Czy przekroczony próg</td>
                                        <td>
                                            <xsl:choose>
                                                <xsl:when test="@czyPrzekroczonyProg = 'true'">TAK</xsl:when>
                                                <xsl:otherwise>NIE</xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                    </tr>
                                </table>
                            </xsl:for-each>
                        </td>
                    </tr>
                </table>

                <!-- osoba 2 -->
                <xsl:if test="count(//osoba2) > 0">
                    <table>
                        <tr>
                            <td colspan='4' align="center">DANE OSOBY 2</td>
                        </tr>
                        <tr>
                            <td class="label">PESEL</td>
                            <td colspan='3'><xsl:value-of select="//osoba2/pesel"/></td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <xsl:for-each select="//osoba2/PIT">
                                    <table>
                                        <tr>
                                            <td class="label">Typ PIT</td>
                                            <td colspan='3'><xsl:value-of select="@typ"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochód</td>
                                            <td><xsl:value-of select="format-number(dochod, '0,00')"/></td>
                                            <td class="label">Dochód małoletnich dzieci</td>
                                            <td><xsl:value-of select="format-number(dochodDzieci, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Składka na ubezpieczenie społeczne</td>
                                            <td><xsl:value-of select="format-number(skladkaUbezpSpol, '0,00')"/></td>
                                            <td class="label">Podatek należny od dochodu</td>
                                            <td><xsl:value-of select="format-number(naleznyPodatek, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochody osiągnięte za granicą</td>
                                            <td><xsl:value-of select="format-number(dochodyOsiagnieteZaGranica, '0,00')"/></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Czy wspólne</td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="czyWspolne = 'true'">TAK</xsl:when>
                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                </xsl:choose></td>
                                            <td class="label">Czy przekroczony próg</td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="@czyPrzekroczonyProg = 'true'">TAK</xsl:when>
                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                        </tr>
                                    </table>
                                </xsl:for-each>
                            </td>
                        </tr>
                    </table>
                </xsl:if>
            </xsl:if>
        </div>

    </xsl:template>
</xsl:stylesheet>

