<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="zadanie">

        <div class="odpowiedz">
            <table>
                <caption>Udostępnienie danych z ePodatki - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>
                <tr>
                    <td class="label">Rok podatkowy</td>
                    <td colspan="3">
                        <xsl:value-of select="//rokPodatkowy"/>
                    </td>
                </tr>
                <tr>
                    <td class="label">Pesel</td>
                    <td colspan="3">
                        <xsl:value-of select="//osoba1/pesel"/>
                    </td>
                </tr>
                <tr>
                    <td class="label">Nazwisko</td>
                    <td>
                        <xsl:value-of select="//osoba1/nazwisko"/>
                    </td>
                    <td class="label">Imię</td>
                    <td>
                        <xsl:value-of select="//osoba1/imie1"/>
                    </td>
                </tr>
                <xsl:if test="count(//osoba2) > 0">
                    <tr>
                        <td class="label">Osoba 2 - Pesel</td>
                        <td colspan="3">
                            <xsl:value-of select="//osoba2/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Osoba 2 - Nazwisko</td>
                        <td>
                            <xsl:value-of select="//osoba2/nazwisko"/>
                        </td>
                        <td class="label">Osoba 2 - Imię</td>
                        <td>
                            <xsl:value-of select="//osoba2/imie1"/>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>