<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpPobierzInformacjeODochodzie">

        <div class="odpowiedz">
            <xsl:apply-templates />
        </div>

    </xsl:template>

    <xsl:template match="statusZlecenia"/>

    <xsl:template match="informacjeODochodzie">
        <hr/>
        <table>
            <caption>INFORMACJE O DOCHODZIE</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = 0"><td colspan="2">Zidentyfikowano osoby i udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 1"><td>Nie znaleziono osób</td><td>Zweryfikuj w  rejestrze  PESEL i sprawdź, czy dane (nr PESEL, Imię pierwsze, Nazwisko) są zgodne - jeśli są zgodne, to należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 2"><td>Niezgodność wspólnego rozliczenia (wspólnie/indywidualnie)</td><td>Komunikat wystąpi, jeśli zapytanie jest na podatnika a zeznanie złożono  wspólnie z małżonkiem bądź, jeśli zapytanie jest jednocześnie na podatnika i małżonka a podatnicy rozliczyli się osobno</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 3"><td>Brak deklaracji podatkowych za podany okres</td><td>Podatnik nie złożył zeznania PIT</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 4"><td>Znaleziono niezatwierdzoną deklarację, dane nie mogą być zwrócone</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 5"><td>Została wydana decyzja wymiarowa, dane nie mogą być zwrócone</td><td>Nie można wydzielić kwoty dochodu - należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 6"><td>Podany w zapytaniu rok nie jest obsługiwany przez usługę</td><td>Dane za rok poprzedni będą dostępne od sierpnia bieżącego roku</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 7"><td>Wskazany w pytaniu podatnik złożył więcej deklaracji tego samego typu w jednym okresie</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 8"><td>Limit dochodu został przekroczony, wyślij zapytanie specjalne by uzyskać informacje</td><td>Dane można uzyskać poprzez wykonanie zapytania specjalnego</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 9"><td>Zidentyfikowano osobę i udostępniono dane </td><td>Dla PIT-36 oraz PIT-37 kwota podatku należnego została obliczona od sumy dochodów obojga podatników, natomiast pozostałe pozycje dotyczą jedynie podatnika, którego dotyczyło zapytanie</td></xsl:when>
                </xsl:choose>
            </tr>
            <xsl:if test="daneODochodach">
                <tr>
                    <td colspan="3">
                        <xsl:apply-templates select="daneODochodach"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>

    <xsl:template match="daneODochodach">
        <table>
            <tr>
                <td class="label">Rok podatkowy</td>
                <td colspan='3'><xsl:value-of select="rokPodatkowy"/></td>
            </tr>
        </table>
        <xsl:if test="osobaPodstawowa">
            <table style="width: 95%; align: center; margin: auto;">
                <tr>
                    <td colspan='4' align="center" style="font-weight: bold;">DANE PODATNIKA</td>
                </tr>
                <tr>
                    <td class="label">PESEL</td>
                    <td colspan='3'><xsl:value-of select="osobaPodstawowa/pesel"/></td>
                </tr>
                <xsl:if test="osobaPodstawowa/pit">
                    <tr>
                        <td colspan="2">
                            <xsl:for-each select="osobaPodstawowa/pit">
                                <xsl:call-template name="pit"/>
                            </xsl:for-each>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </xsl:if>
        <xsl:if test="osobaDodatkowa">
            <br/>
            <table style="width: 95%; align: center; margin: auto;">
                <tr>
                    <td colspan='4' align="center" style="font-weight: bold;">DANE WSPÓŁMAŁŻONKA/DZIECKA</td>
                </tr>
                <tr>
                    <td class="label">PESEL</td>
                    <td colspan='3'>
                        <xsl:value-of select="osobaDodatkowa/pesel"/>
                    </td>
                    <xsl:if test="osobaDodatkowa/pit">
                        <tr>
                            <td colspan="2">
                                <xsl:for-each select="osobaDodatkowa/pit">
                                    <xsl:call-template name="pit"/>
                                </xsl:for-each>
                            </td>
                        </tr>
                    </xsl:if>
                </tr>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template name="pit">
        <br/>
        <table style="width: 80%; align: center; margin: auto;">
            <tr>
                <td rowspan="7" class="label" style="width: 10%">
                    Typ PIT: <xsl:value-of select="@typ"/>
                </td>
                <xsl:if test="@czyLimit = 'true'">
                    <td class="label">Przekroczony limit</td>
                    <td>Przekroczony został limit powyżej którego dane są udostępniane tylko na specjalne życzenie instytucji zewnętrznej</td>
                </xsl:if>
            </tr>
            <tr>
                <td class="label">Czy deklaracja była rozliczana przez współmałżonków</td>
                <td class="opcjonalne">
                    <xsl:choose>
                        <xsl:when test="czyWspolne = 'T'">TAK</xsl:when>
                        <xsl:when test="czyWspolne = 'N'">NIE</xsl:when>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td class="label">Dochód</td>
                <td><xsl:value-of select="format-number(dochod, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód małoletnich</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(dochodMaloletnich, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Składka na ubezpieczenie społeczne</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(skladkaUbezpSpol, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Podatek należny od dochodu</td>
                <td><xsl:value-of select="format-number(naleznyPodatek, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochody osiągnięte za granicą</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(dochodyOsiagnieteZaGranica, '0,00')"/></td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>