<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpPobierzWysokoscPrzychoduRE">

        <div class="odpowiedz">
            <xsl:apply-templates />
        </div>

    </xsl:template>

    <xsl:template match="statusZlecenia"/>

    <xsl:template match="wysokoscPrzychoduRE">
        <hr/>
        <table>
            <caption>INFORMACJE O PRZYCHODZIE DOT. RYCZAŁTU OD PRZYCHODÓW EWIDENCJONOWANYCH</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = '0B'"><td>Udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '2B'"><td>Niezgodność sposobu rozliczenia (za podany okres istnieje wspólne zeznanie PIT-36/37)</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '3B'"><td>Brak danych w zakresie zapytania</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '4B'"><td>Znaleziono niezatwierdzony dokument, dane nie mogą zostać zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '5B'"><td>Została wydana decyzja wymiarowa do deklaracji, dane nie mogą zostać zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '6B'"><td>Podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '7B'"><td>Wskazany/i w pytaniu podatnik/cy złożył/li więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                </xsl:choose>
            </tr>
            <xsl:if test="listaPrzychodow">
                <tr>
                    <td colspan="2">
                        <table style="width: 70%; align: center; margin: auto;">
                            <caption>Lista przychodów</caption>
                            <th>Stawka ryczałtu od przychodów ewidencjonowanych w procentach</th>
                            <th>Wysokość przychodu wykazana przez podatnika</th>
                            <th>Wysokość przychodu określona przez organ</th>
                            <xsl:for-each select="listaPrzychodow/przychod">
                                <tr>
                                    <td><xsl:value-of select="format-number(stawka, '0,00')"/></td>
                                    <td class="opcjonalne"><xsl:value-of select="format-number(wysokoscWykazana, '0,00')"/></td>
                                    <td class="opcjonalne"><xsl:value-of select="format-number(wysokoscOkreslona, '0,00')"/></td>
                                </tr>
                            </xsl:for-each>
                        </table>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td class="label">Przychód zwolniony art. 21 ust. 1 pkt 152 ustawy o PIT z pozarolniczej działalności gospodarczej</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(przychodZwolnionyDzialPozarolUlgaNaPowrot, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony art. 21 ust. 1 pkt 153 ustawy o PIT z pozarolniczej działalności gospodarczej</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(przychodZwolnionyDzialPozarolUlga4Plus, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony art. 21 ust. 1 pkt 154 ustawy o PIT z pozarolniczej działalności gospodarczej</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(przychodZwolnionyDzialPozarolUlgaWiekEmerytalny, '0,00')"/></td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>