<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

    <xsl:include href="zadanieDochody.xslt"/>
    <xsl:include href="zadanieDuchowniKartaRyczalt.xslt"/>
    <xsl:include href="zadaniePrzychodyZwolnioneKwotaZwrotu.xslt"/>

    <xsl:include href="KodpPobierzInformacjeODochodzie.xslt"/>
    <xsl:include href="KodpPobierzInformacjeOPrzychodachZwolnionych.xslt"/>
    <xsl:include href="KodpPobierzKwotePodatkuNaleznegoDuchownych.xslt"/>
    <xsl:include href="KodpPobierzKwotePodatkuZDecyzjiKP.xslt"/>
    <xsl:include href="KodpPobierzKwoteZwrotu.xslt"/>
    <xsl:include href="KodpPobierzWysokoscPrzychoduRE.xslt"/>

    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../css/style.html')/html/head/style"/>
                    .label {
                        text-align: right;
                    }
                    .opcjonalne:empty::after {
                        content: "BRAK DANYCH";
                    }
                </style>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="local-name(/*) = 'KzadPrzygotujInformacjeODochodzie'">
                        <xsl:call-template name="zadanieDochody"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KzadPrzygotujKwoteZwrotu'">
                        <xsl:call-template name="zadaniePrzychodyZwolnioneKwotaZwrotu"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KzadPrzygotujInformacjeOPrzychodachZwolnionych'">
                        <xsl:call-template name="zadaniePrzychodyZwolnioneKwotaZwrotu"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KzadPrzygotujKwotePodatkuZDecyzjiKP'">
                        <xsl:call-template name="zadanieDuchowniKartaRyczalt"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KzadPrzygotujWysokoscPrzychoduRE'">
                        <xsl:call-template name="zadanieDuchowniKartaRyczalt"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KzadPrzygotujKwotePodatkuNaleznegoDuchownych'">
                        <xsl:call-template name="zadanieDuchowniKartaRyczalt"/>
                    </xsl:when>

                    <xsl:when test="local-name(/*) = 'KodpPobierzInformacjeODochodzie'">
                        <xsl:call-template name="KodpPobierzInformacjeODochodzie"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpPobierzInformacjeOPrzychodachZwolnionych'">
                        <xsl:call-template name="KodpPobierzInformacjeOPrzychodachZwolnionych"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpPobierzKwotePodatkuNaleznegoDuchownych'">
                        <xsl:call-template name="KodpPobierzKwotePodatkuNaleznegoDuchownych"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpPobierzKwotePodatkuZDecyzjiKP'">
                        <xsl:call-template name="KodpPobierzKwotePodatkuZDecyzjiKP"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpPobierzKwoteZwrotu'">
                        <xsl:call-template name="KodpPobierzKwoteZwrotu"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpPobierzWysokoscPrzychoduRE'">
                        <xsl:call-template name="KodpPobierzWysokoscPrzychoduRE"/>
                    </xsl:when>

                    <xsl:otherwise>
                        <xsl:text>Nieznany root element !</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>