<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KzadUdostepnianieDanychPesel">

        <div class="odpowiedz">
            <table>
                <caption>Udostępnienie danych z PESEL - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>
                <xsl:if test="count(//kryteriaWymPesel) > 0">
                    <tr>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//imie1"/>
                        </td>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//nazwisko1/nazwisko"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//dataUrodzenia"/>
                        </td>
                        <td class="label">Pesel</td>
                        <td>
                            <xsl:value-of select="//pesel/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nr dokumentu tożsamości</td>
                        <td>
                            <xsl:value-of select="//seriaNrDokumentu"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Ulica</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/ulica"/>
                        </td>
                        <td class="label">Nr domu</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/nrDomu"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteriaWymDaneOsoby) > 0">
                    <tr>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//imie1"/>
                        </td>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//nazwisko1/nazwisko"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//dataUrodzenia"/>
                        </td>
                        <td class="label">Pesel</td>
                        <td>
                            <xsl:value-of select="//pesel/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nr dokumentu tożsamości</td>
                        <td>
                            <xsl:value-of select="//seriaNrDokumentu/seriaNrDokumnetu"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Ulica</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/ulica"/>
                        </td>
                        <td class="label">Nr domu</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/nrDomu"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteriaWymDokument) > 0">
                    <tr>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//imie1"/>
                        </td>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//nazwisko1/nazwisko"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//dataUrodzenia"/>
                        </td>
                        <td class="label">Pesel</td>
                        <td>
                            <xsl:value-of select="//pesel/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nr dokumentu tożsamości</td>
                        <td>
                            <xsl:value-of select="//seriaNrDokumentu"/>
                        </td>
                        <td class="label">Miejscowość</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/miejscowosc"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Ulica</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/ulica"/>
                        </td>
                        <td class="label">Nr domu</td>
                        <td>
                            <xsl:value-of select="//daneAdresowe/nrDomu"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteriaWymListaPesel) > 0">
                    <xsl:for-each select="//kryteriaWymListaPesel/osoba">
                        <tr>
                            <td class="label">PESEL</td>
                            <td><xsl:value-of select="pesel/pesel"/></td>
                        </tr>
                    </xsl:for-each>
                    <tr>
                        <td class="label">Liczba osób przekazanych do zapytania</td>
                        <td><xsl:value-of select="count(//kryteriaWymListaPesel/osoba)"/></td>
                    </tr>
                </xsl:if>
            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>