<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/" name="KodpWeryfikacjaOsobyWPesel">
        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź z usługi</caption>
                <tr>
                    <td class="label">Liczba znalezionych osób</td>
                    <td><xsl:value-of select="//odpowiedzWeryfikacjaOsobyWPesel/liczbaWynikow"/></td>
                </tr>
            </table>
            <xsl:for-each select="//odpowiedzWeryfikacjaOsobyWPesel/niezgodnosci">
                <table>
                    <xsl:if test="pesel">
                        <tr>
                            <td class="label">Numer pesel osoby</td>
                            <td>
                                <xsl:value-of select="pesel"/>
                            </td>
                        </tr>
                    </xsl:if>
                    <tr>
                        <td colspan="2">
                            <xsl:if test="daneOsoby">
                                <table>
                                    <tr>
                                        <td class="label">Nazwisko</td>
                                        <td><xsl:value-of select="daneOsoby/nazwisko1"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Imię</td>
                                        <td><xsl:value-of select="daneOsoby/imie1"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">PESEL</td>
                                        <td><xsl:value-of select="daneOsoby/pesel"/></td>
                                    </tr>
                                    <xsl:if test="daneOsoby/dataUrodzenia">
                                        <tr>
                                            <td class="label">Data urodzenia</td>
                                            <td><xsl:value-of select="daneOsoby/dataUrodzenia"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneOsoby/imie2">
                                        <tr>
                                            <td class="label">Imię drugie</td>
                                            <td><xsl:value-of select="daneOsoby/imie2"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneOsoby/nazwisko2">
                                    <tr>
                                        <td class="label">Nazwisko drugie</td>
                                        <td><xsl:value-of select="daneOsoby/nazwisko2"/></td>
                                    </tr>
                                    </xsl:if>
                                    <xsl:if test="daneOsoby/seriaNrDokumentu">
                                        <tr>
                                            <td class="label">Seria i numer dokumentu</td>
                                            <td><xsl:value-of select="daneOsoby/seriaNrDokumentu"/></td>
                                        </tr>
                                    </xsl:if>
                                </table>
                            </xsl:if>
                            <xsl:if test="daneUrodzenia">
                                <table>
                                    <xsl:if test="daneUrodzenia/imieMatki">
                                        <tr>
                                            <td class="label">Imię matki</td>
                                            <td><xsl:value-of select="daneUrodzenia/imieMatki"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneUrodzenia/imieOjca">
                                        <tr>
                                            <td class="label">Imię ojca</td>
                                            <td><xsl:value-of select="daneUrodzenia/imieOjca"/></td>
                                        </tr>
                                    </xsl:if>
                                </table>
                            </xsl:if>
                            <xsl:if test="daneAdresowe">
                                <table>
                                    <xsl:if test="daneAdresowe/kodPocztowy">
                                        <tr>
                                            <td class="label">Kod pocztowy</td>
                                            <td><xsl:value-of select="daneAdresowe/kodPocztowy"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneAdresowe/miejscowosc">
                                        <tr>
                                            <td class="label">Miejscowość</td>
                                            <td><xsl:value-of select="daneAdresowe/miejscowosc"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneAdresowe/nrDomu">
                                        <tr>
                                            <td class="label">Nr domu</td>
                                            <td><xsl:value-of select="daneAdresowe/nrDomu"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneAdresowe/nrLokalu">
                                        <tr>
                                            <td class="label">Nr lokalu</td>
                                            <td><xsl:value-of select="daneAdresowe/nrLokalu"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneAdresowe/ulica">
                                        <tr>
                                            <td class="label">Ulica</td>
                                            <td><xsl:value-of select="daneAdresowe/ulica"/></td>
                                        </tr>
                                    </xsl:if>
                                    <xsl:if test="daneAdresowe/wojewodztwo">
                                        <tr>
                                            <td class="label">Województwo</td>
                                            <td><xsl:value-of select="daneAdresowe/wojewodztwo"/></td>
                                        </tr>
                                    </xsl:if>
                                </table>
                            </xsl:if>
                        </td>
                    </tr>
                </table>
            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>

