<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="kodpPobranieWynikuZleceniaDaneUbezp">
        <div class="odpowiedz">
            <table>
                <caption>Usługa ZUS - odpowiedź</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <td colspan="3">
                        <xsl:choose>
                            <xsl:when test="//statusZlecenia = -1">brak podanego identyfikatora zlecenia</xsl:when>
                            <xsl:when test="//statusZlecenia = 0">osoba została znaleziona, są dane</xsl:when>
                            <xsl:when test="//statusZlecenia = 1">osoba została znaleziona, brak danych</xsl:when>
                            <xsl:when test="//statusZlecenia = 2">osoba nie została znaleziona</xsl:when>
                            <xsl:when test="//statusZlecenia = 3">znaleziono wiele osób, konieczne doprecyzowanie kryteriów</xsl:when>
                            <xsl:when test="//statusZlecenia = 4">dane nie zostały jeszcze przygotowane</xsl:when>
                        </xsl:choose>
                    </td>
                </tr>
                <xsl:if test="//okresBrakujacy">
                    <xsl:text>Wynik zlecenia udostępnienia brakujących miesięcy i dni do uzyskania uprawnień emerytalno-rentowych</xsl:text>
                    <tr>
                        <td class="label">Liczba miesięcy</td>
                        <td><xsl:value-of select="//okresBrakujacy/liczbaMiesiecy"/></td>
                        <td class="label">Liczba dni</td>
                        <td><xsl:value-of select="//okresBrakujacy/liczbaDni"/></td>
                    </tr>
                </xsl:if>
            </table>
        </div>
    </xsl:template>
</xsl:stylesheet>
