<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times">

    <xsl:template match="/" name="kodpPobranieWynikuZleceniaSkladki">
        <div class="odpowiedz">
            <table>
                <caption>Usługa ZUS - odpowiedź</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <td colspan="2">
                        <xsl:choose>
                            <xsl:when test="//statusZlecenia = -1">brak podanego identyfikatora zlecenia</xsl:when>
                            <xsl:when test="//statusZlecenia = -2">wiele kodów tytułu ubezpieczenia</xsl:when>
                            <xsl:when test="//statusZlecenia = -3">błąd odpowiedzi ZUS</xsl:when>
                            <xsl:when test="//statusZlecenia = 0">osoba została znaleziona, są dane</xsl:when>
                            <xsl:when test="//statusZlecenia = 1">osoba została znaleziona, brak danych</xsl:when>
                            <xsl:when test="//statusZlecenia = 2">osoba nie została znaleziona</xsl:when>
                            <xsl:when test="//statusZlecenia = 3">znaleziono wiele osób, konieczne doprecyzowanie kryteriów</xsl:when>
                            <xsl:when test="//statusZlecenia = 4">dane nie zostały jeszcze przygotowane</xsl:when>
                        </xsl:choose>
                    </td>
                </tr>
                <xsl:if test="//opis">
                    <tr>
                        <td class="label">Opis</td>
                        <td colspan="2">
                            <xsl:value-of select="//opis"/>
                        </td>
                    </tr>
                </xsl:if>
            </table>
            <xsl:if test="count(//skladkiUbezpZdrowotne) > 0">
                <b>SKŁADKI ZDROWOTNE</b>
                <xsl:for-each select="//skladkiUbezpZdrowotne">
                    <table style="margin-bottom: 20px">
                        <tr>
                            <td class="label">Data uzyskania uprawnień</td>
                            <td><xsl:value-of select="date:formatDate(dataUzyskaniaUprawnien, 'yyyy-MM-dd')" /></td>
                            <td class="label">Data utraty uprawnień</td>
                            <td>
                                <xsl:choose>
                                    <xsl:when test="dataUtratyUprawnien">
                                        <xsl:value-of select="date:formatDate(dataUtratyUprawnien, 'yyyy-MM-dd')" />
                                    </xsl:when>
                                    <xsl:otherwise>BRAK</xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Czy obowiązkowe</td>
                            <td colspan="3">
                                <xsl:choose>
                                    <xsl:when test="daneOUbezpieczeniu/czyObowiązkowe">TAK</xsl:when>
                                    <xsl:otherwise>NIE</xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">NIP Płatnika</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/nipPlatnika"/></td>
                            <td class="label">Nazwa płatnika</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/nazwaPlatnika"/></td>
                        </tr>
                        <xsl:if test="daneOUbezpieczeniu/nazwiskoPlatnika or daneOUbezpieczeniu/imiePlatnika">
                            <tr>
                                <td class="label">Nazwisko płatnika</td>
                                <td><xsl:value-of select="daneOUbezpieczeniu/nazwiskoPlatnika"/></td>
                                <td class="label">Imię płatnika</td>
                                <td><xsl:value-of select="daneOUbezpieczeniu/imiePlatnika"/></td>
                            </tr>
                        </xsl:if>
                        <tr>
                            <td class="label">Kod tytułu ubezpieczenia</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/kodTytuluUbezpieczenia"/></td>
                            <td class="label">Nazwa tytułu ubezpieczenia</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/nazwaTytuluUbezpieczenia"/></td>
                        </tr>

                        <xsl:if test="listaKwotSkladek and listaKwotSkladek/kwotaSkladki/kwota">
                            <tr>
                                <td colspan="4">
                                    <table style="width: 70%; margin: auto;">
                                        <tr>
                                            <th>Okres raportowy</th>
                                            <th>Kwota składki</th>
                                        </tr>
                                        <xsl:for-each select="listaKwotSkladek/kwotaSkladki">
                                            <tr>

                                                <xsl:variable name="year" select="substring(okresRaportowy, 1, 4)"/>
                                                <xsl:variable name="month" select="substring(okresRaportowy, 5, 2)"/>
                                                <td><xsl:value-of select="concat($year, '/', $month)"/></td>
                                                <td><xsl:value-of select="format-number(kwota, '0,00')"/></td>
                                            </tr>
                                        </xsl:for-each>
                                    </table>
                                </td>
                            </tr>
                        </xsl:if>

                        <xsl:if test="rodzajUbezpieczenia">
                            <tr>
                                <td class="label">Rodzaj ubezpieczenia</td>
                                <td><xsl:value-of select="rodzajUbezpieczenia"/></td>
                                <td class="label">Suma składek</td>
                                <td class="pogrubione"><xsl:value-of select="format-number(sum(listaKwotSkladek/kwotaSkladki/kwota), '0,00')"></xsl:value-of></td>
                            </tr>
                        </xsl:if>
                    </table>
                </xsl:for-each>
            </xsl:if>

            <xsl:if test="count(//skladkiUbezpSpoleczne) > 0">
                <b>SKŁADKI SPOŁECZNE</b>
                <xsl:for-each select="//skladkiUbezpSpoleczne">
                    <table>
                        <tr>
                            <td class="label">Data zgłoszenia</td>
                            <td><xsl:value-of select="dataZgloszenia" /></td>
                            <td class="label">Data wyrejestrowania</td>
                            <td>
                                <xsl:choose>
                                    <xsl:when test="dataWyrejestrowania">
                                        <xsl:value-of select="dataWyrejestrowania" />
                                    </xsl:when>
                                    <xsl:otherwise>BRAK</xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Czy obowiązkowe</td>
                            <td colspan="3">
                                <xsl:choose>
                                    <xsl:when test="daneOUbezpieczeniu/czyObowiązkowe">TAK</xsl:when>
                                    <xsl:otherwise>NIE</xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">NIP Płatnika</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/nipPlatnika"/></td>
                            <td class="label">Nazwa płatnika</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/nazwaPlatnika"/></td>
                        </tr>
                        <xsl:if test="daneOUbezpieczeniu/nazwiskoPlatnika or daneOUbezpieczeniu/imiePlatnika">
                            <tr>
                                <td class="label">Nazwisko płatnika</td>
                                <td><xsl:value-of select="daneOUbezpieczeniu/nazwiskoPlatnika"/></td>
                                <td class="label">Imię płatnika</td>
                                <td><xsl:value-of select="daneOUbezpieczeniu/imiePlatnika"/></td>
                            </tr>
                        </xsl:if>
                        <tr>
                            <td class="label">Kod tytułu ubezpieczenia</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/kodTytuluUbezpieczenia"/></td>
                            <td class="label">Nazwa tytułu ubezpieczenia</td>
                            <td><xsl:value-of select="daneOUbezpieczeniu/nazwaTytuluUbezpieczenia"/></td>
                        </tr>
                        <tr>
                            <td class="label">Rodzaj ubezpieczenia</td>
                            <td colspan='3'><xsl:value-of select="rodzajUbezpieczenia"/></td>
                        </tr>
                    </table>
                </xsl:for-each>
            </xsl:if>
        </div>

    </xsl:template>
</xsl:stylesheet>
