/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.Immutable;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import java.util.stream.Stream;
import org.checkerframework.checker.index.qual.NonNegative;
import pl.topteam.common.primitives.ExtraInts;

@Immutable
public final class Separator {
    private final ImmutableIntArray lengths;
    private final ImmutableIntArray start;
    private final ImmutableIntArray end;
    private final int sumOfLengths;

    public static Separator fixedLengths(int ... lengths) {
        Preconditions.checkNotNull((Object)lengths);
        Preconditions.checkArgument((lengths.length > 0 ? 1 : 0) != 0, (Object)"Nie zadano d\u0142ugo\u015bci segment\u00f3w");
        Preconditions.checkArgument((Ints.min((int[])lengths) > 0 ? 1 : 0) != 0, (Object)"Wszystkie d\u0142ugo\u015bci musz\u0105 by\u0107 dodatnie");
        return new Separator(lengths);
    }

    public Iterable<String> separate(CharSequence sequence) {
        return this.separateToList(sequence);
    }

    public List<String> separateToList(CharSequence sequence) {
        Preconditions.checkNotNull((Object)sequence);
        this.checkLength(sequence);
        return new SeparatingList(sequence);
    }

    @Beta
    public Stream<String> separateToStream(CharSequence sequence) {
        return this.separateToList(sequence).stream();
    }

    private Separator(int ... lengths) {
        int i;
        int[] start = new int[lengths.length];
        int[] end = new int[lengths.length];
        for (i = 1; i < lengths.length; ++i) {
            start[i] = start[i - 1] + lengths[i - 1];
        }
        for (i = 0; i < lengths.length; ++i) {
            end[i] = start[i] + lengths[i];
        }
        this.start = ImmutableIntArray.copyOf((int[])start);
        this.end = ImmutableIntArray.copyOf((int[])end);
        this.lengths = ImmutableIntArray.copyOf((int[])lengths);
        this.sumOfLengths = ExtraInts.sum(lengths);
    }

    private void checkLength(CharSequence sequence) {
        Preconditions.checkArgument((sequence.length() == this.sumOfLengths ? 1 : 0) != 0, (String)"D\u0142ugo\u015b\u0107 sekwencji (%s) nie jest r\u00f3wna sumie d\u0142ugo\u015bci segment\u00f3w (%s)", (int)sequence.length(), (int)this.sumOfLengths);
    }

    private final class SeparatingList
    extends AbstractList<String>
    implements RandomAccess {
        private final CharSequence sequence;

        private SeparatingList(CharSequence sequence) {
            this.sequence = sequence;
        }

        @Override
        public String get(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size());
            int _start = Separator.this.start.get(index);
            int _end = Separator.this.end.get(index);
            assert (_start >= 0) : "@AssumeAssertion(index): Zagwarantowane w konstruktorze";
            assert (_start <= this.sequence.length()) : "@AssumeAssertion(index): Zagwarantowane w konstruktorze";
            assert (_end >= 0) : "@AssumeAssertion(index): Zagwarantowane w konstruktorze";
            assert (_end <= this.sequence.length()) : "@AssumeAssertion(index): Zagwarantowane w konstruktorze";
            return this.sequence.subSequence(_start, _end).toString();
        }

        @Override
        public @NonNegative int size() {
            return Separator.this.lengths.length();
        }
    }
}

