/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.errorprone.annotations.Immutable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import pl.topteam.common.collect.ExtraDiscreteDomains;

@Immutable
public final class KalkulatorOdsetek {
    public static final int DOMYSLNA_SKALA = 2;
    public static final RoundingMode DOMYSLNY_TRYB = RoundingMode.HALF_UP;
    private final RoundingMode tryb;
    private final int skala;

    public KalkulatorOdsetek() {
        this.skala = 2;
        this.tryb = DOMYSLNY_TRYB;
    }

    public KalkulatorOdsetek(int skala) {
        this.skala = skala;
        this.tryb = DOMYSLNY_TRYB;
    }

    public KalkulatorOdsetek(RoundingMode tryb) {
        this.skala = 2;
        this.tryb = (RoundingMode)((Object)Preconditions.checkNotNull((Object)((Object)tryb)));
    }

    public KalkulatorOdsetek(int skala, RoundingMode tryb) {
        this.skala = skala;
        this.tryb = (RoundingMode)((Object)Preconditions.checkNotNull((Object)((Object)tryb)));
    }

    public BigDecimal odsetki(BigDecimal kwota, RangeMap<LocalDate, BigDecimal> stawki, Range<LocalDate> okres) {
        Preconditions.checkNotNull((Object)kwota);
        Preconditions.checkNotNull(stawki);
        Preconditions.checkNotNull(okres);
        return stawki.subRangeMap(okres).asMapOfRanges().entrySet().stream().map(wpis -> {
            BigDecimal stawka = (BigDecimal)wpis.getValue();
            Range podokres = (Range)wpis.getKey();
            return this.odsetki(kwota, stawka, this.dni((Range<LocalDate>)podokres));
        }).reduce(this.zero(), BigDecimal::add);
    }

    public BigDecimal odsetki(BigDecimal kwota, BigDecimal stawka, long dni) {
        Preconditions.checkNotNull((Object)kwota);
        Preconditions.checkNotNull((Object)stawka);
        return kwota.multiply(stawka).multiply(BigDecimal.valueOf(dni)).divide(BigDecimal.valueOf(36500L), this.skala, this.tryb);
    }

    private long dni(Range<LocalDate> okres) {
        Preconditions.checkArgument((boolean)okres.hasLowerBound());
        Preconditions.checkArgument((boolean)okres.hasUpperBound());
        ContiguousSet zbior = ContiguousSet.create(okres, ExtraDiscreteDomains.localDates());
        return zbior.isEmpty() ? 0L : ExtraDiscreteDomains.localDates().distance((Comparable)((LocalDate)zbior.first()), (Comparable)((LocalDate)zbior.last())) + 1L;
    }

    private BigDecimal zero() {
        return BigDecimal.ZERO.setScale(this.skala);
    }
}

