/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Immutable(containerOf={"N"})
@Beta
public final class Edge<N> {
    private final N parent;
    private final N child;

    public Edge(N parent, N child) {
        this.parent = Preconditions.checkNotNull(parent);
        this.child = Preconditions.checkNotNull(child);
    }

    public N parent() {
        return this.parent;
    }

    public N child() {
        return this.child;
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)object;
        return this.parent.equals(other.parent) && this.child.equals(other.child);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.child);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parent", this.parent).add("child", this.child).toString();
    }
}

