/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Optional;

@Beta
public final class ExtraRanges {
    private ExtraRanges() {
    }

    public static <C extends Comparable<? super C>> Range<C> downTo(Optional<C> endpoint, BoundType boundType) {
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkNotNull((Object)boundType);
        return endpoint.isPresent() ? Range.downTo((Comparable)((Comparable)endpoint.get()), (BoundType)boundType) : Range.all();
    }

    public static <C extends Comparable<? super C>> Range<C> upTo(Optional<C> endpoint, BoundType boundType) {
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkNotNull((Object)boundType);
        return endpoint.isPresent() ? Range.upTo((Comparable)((Comparable)endpoint.get()), (BoundType)boundType) : Range.all();
    }

    public static <C extends Comparable<? super C>> Range<C> range(Optional<C> lower, BoundType lowerType, Optional<C> upper, BoundType upperType) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull((Object)lowerType);
        Preconditions.checkNotNull(upper);
        Preconditions.checkNotNull((Object)upperType);
        Range<C> lowerBound = ExtraRanges.downTo(lower, lowerType);
        Range<C> upperBound = ExtraRanges.upTo(upper, upperType);
        return lowerBound.intersection(upperBound);
    }

    public static <C extends Comparable<? super C>> Range<C> open(Optional<C> lower, Optional<C> upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return ExtraRanges.range(lower, BoundType.OPEN, upper, BoundType.OPEN);
    }

    public static <C extends Comparable<? super C>> Range<C> closed(Optional<C> lower, Optional<C> upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return ExtraRanges.range(lower, BoundType.CLOSED, upper, BoundType.CLOSED);
    }

    public static <C extends Comparable<? super C>> Range<C> closedOpen(Optional<C> lower, Optional<C> upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return ExtraRanges.range(lower, BoundType.CLOSED, upper, BoundType.OPEN);
    }

    public static <C extends Comparable<? super C>> Range<C> openClosed(Optional<C> lower, Optional<C> upper) {
        Preconditions.checkNotNull(lower);
        Preconditions.checkNotNull(upper);
        return ExtraRanges.range(lower, BoundType.OPEN, upper, BoundType.CLOSED);
    }

    public static <C extends Comparable<? super C>> Range<C> lessThan(Optional<C> endpoint) {
        Preconditions.checkNotNull(endpoint);
        return ExtraRanges.upTo(endpoint, BoundType.OPEN);
    }

    public static <C extends Comparable<? super C>> Range<C> atMost(Optional<C> endpoint) {
        Preconditions.checkNotNull(endpoint);
        return ExtraRanges.upTo(endpoint, BoundType.CLOSED);
    }

    public static <C extends Comparable<? super C>> Range<C> greaterThan(Optional<C> endpoint) {
        Preconditions.checkNotNull(endpoint);
        return ExtraRanges.downTo(endpoint, BoundType.OPEN);
    }

    public static <C extends Comparable<? super C>> Range<C> atLeast(Optional<C> endpoint) {
        Preconditions.checkNotNull(endpoint);
        return ExtraRanges.downTo(endpoint, BoundType.CLOSED);
    }
}

