/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.collect.Edge;
import pl.topteam.common.collect.EdgeSet;
import pl.topteam.common.collect.Printer;
import pl.topteam.common.collect.Stringifier;

@NullMarked
@Immutable(containerOf={"N"})
public final class Forest<N> {
    private final ImmutableSet<N> nodes;
    private final ImmutableMap<N, N> parents;
    private final ImmutableSetMultimap<N, N> children;
    private final ImmutableSet<N> roots;

    private Forest(ImmutableSet<N> nodes, ImmutableMap<N, N> parents, ImmutableSetMultimap<N, N> children, ImmutableSet<N> roots) {
        this.nodes = (ImmutableSet)Preconditions.checkNotNull(nodes);
        this.parents = (ImmutableMap)Preconditions.checkNotNull(parents);
        this.children = (ImmutableSetMultimap)Preconditions.checkNotNull(children);
        this.roots = (ImmutableSet)Preconditions.checkNotNull(roots);
    }

    public Set<N> roots() {
        return this.roots;
    }

    public Optional<N> parent(N node) {
        Preconditions.checkNotNull(node);
        Preconditions.checkArgument((boolean)this.nodes.contains(node));
        Object parent = this.parents.get(node);
        return Optional.ofNullable(parent);
    }

    public Set<N> children(N node) {
        Preconditions.checkNotNull(node);
        Preconditions.checkArgument((boolean)this.nodes.contains(node));
        return this.children.get(node);
    }

    public static <N> Builder<N> builder() {
        return new Builder();
    }

    @Beta
    public Set<N> nodes() {
        return this.nodes;
    }

    @Beta
    public Set<Edge<N>> edges() {
        return new EdgeSet<N>(this.parents);
    }

    @Beta
    public void print() throws IOException {
        Printer.forTree(this::children).print((Iterable<N>)this.roots());
    }

    @Beta
    public void printTo(Appendable appendable) throws IOException {
        Preconditions.checkNotNull((Object)appendable);
        Printer.forTree(this::children).appendingTo(appendable).print((Iterable<N>)this.roots());
    }

    public int hashCode() {
        return this.parents.hashCode();
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Forest)) {
            return false;
        }
        Forest other = (Forest)object;
        return this.nodes.equals(other.nodes) && this.parents.equals(other.parents);
    }

    public String toString() {
        return Stringifier.forTree(this::children).stringify((Iterable<N>)this.roots);
    }

    @NullMarked
    public static final class Builder<N> {
        private final ImmutableMap.Builder<N, N> parents = ImmutableMap.builder();
        private final ImmutableSetMultimap.Builder<N, N> children = ImmutableSetMultimap.builder();
        private final ImmutableSet.Builder<N> roots = ImmutableSet.builder();
        private final Set<N> nodes = new LinkedHashSet<N>();

        private Builder() {
        }

        public Builder<N> add(N root) {
            Preconditions.checkNotNull(root);
            Preconditions.checkState((!this.nodes.contains(root) ? 1 : 0) != 0);
            this.roots.add(root);
            this.nodes.add(root);
            return this;
        }

        public Builder<N> add(N parent, N child) {
            Preconditions.checkNotNull(parent);
            Preconditions.checkNotNull(child);
            Preconditions.checkState((boolean)this.nodes.contains(parent));
            Preconditions.checkState((!this.nodes.contains(child) ? 1 : 0) != 0);
            this.parents.put(child, parent);
            this.children.put(parent, child);
            this.nodes.add(child);
            return this;
        }

        public Forest<N> build() {
            return new Forest(ImmutableSet.copyOf(this.nodes), this.parents.build(), this.children.build(), this.roots.build());
        }
    }
}

