/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

final class TopologicalOrdering {
    private TopologicalOrdering() {
    }

    public static <N> List<N> of(Graph<N> graph) {
        Preconditions.checkNotNull(graph, (Object)"Graph is null");
        Preconditions.checkArgument((boolean)graph.isDirected(), (Object)"Graph is undirected");
        Preconditions.checkArgument((!Graphs.hasCycle(graph) ? 1 : 0) != 0, (Object)"Graph has at least one cycle");
        Traverser traverser = Traverser.forGraph(graph);
        ArrayList sorted = new ArrayList();
        HashSet visited = new HashSet();
        for (Object node : graph.nodes()) {
            if (visited.contains(node)) continue;
            for (Object traversed : traverser.depthFirstPostOrder(node)) {
                if (!visited.add(traversed)) continue;
                sorted.add(traversed);
            }
        }
        Collections.reverse(sorted);
        return sorted;
    }
}

