/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.i18n;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.grammar.Przypadek;

@NullMarked
final class Deklinacja {
    private Deklinacja() {
    }

    public static NavigableMap<Long, ?> wczytaj(String zasob, Class<?> ... kategorie) {
        HashMap<Long, Object> _deklinacja = new HashMap<Long, Object>();
        int[] wymiary = Deklinacja.wymiary(kategorie);
        try {
            URL url = Resources.getResource((String)zasob);
            for (String wiersz : Resources.readLines((URL)url, (Charset)StandardCharsets.UTF_8)) {
                String[] kolumny = (String[])Splitter.on((String)",").splitToStream((CharSequence)wiersz).toArray(String[]::new);
                Long klucz = Long.valueOf(kolumny[0]);
                if (!_deklinacja.containsKey(klucz)) {
                    _deklinacja.put(klucz, Array.newInstance(String.class, wymiary));
                }
                List zbiory = IntStream.range(0, kategorie.length - 1).mapToObj(i -> Deklinacja.zbior(kategorie[i], kolumny[1 + i])).collect(Collectors.toList());
                for (List indeksy : Lists.cartesianProduct(zbiory)) {
                    String[] deklinacja = (String[])Deklinacja.nawiguj(_deklinacja.get(klucz), Ints.toArray((Collection)indeksy));
                    for (Przypadek przypadek : Przypadek.values()) {
                        String wartosc;
                        deklinacja[przypadek.ordinal()] = wartosc = kolumny[kategorie.length + przypadek.ordinal()];
                    }
                }
            }
        }
        catch (IOException wyjatek) {
            throw new UncheckedIOException(wyjatek);
        }
        return ImmutableSortedMap.copyOf(_deklinacja);
    }

    private static int[] wymiary(Class<?> ... kategorie) {
        return Arrays.stream(kategorie).map(Class::getEnumConstants).mapToInt(Array::getLength).toArray();
    }

    private static List<Integer> zbior(Class<?> klasa, String nazwa) {
        return nazwa.isEmpty() ? Ints.asList((int[])Deklinacja.indeksy(klasa)) : Ints.asList((int[])new int[]{Deklinacja.indeks(klasa, nazwa)});
    }

    private static Object nawiguj(Object tablica, int ... indeksy) {
        Object obiekt = tablica;
        for (int indeks : indeksy) {
            obiekt = Array.get(obiekt, indeks);
        }
        return obiekt;
    }

    private static int[] indeksy(Class<?> klasa) {
        return IntStream.range(0, klasa.getEnumConstants().length).toArray();
    }

    private static int indeks(Class<?> klasa, String nazwa) {
        return ((Enum)Enum.valueOf(klasa, nazwa)).ordinal();
    }
}

