/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.i18n;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.NonNull;
import pl.topteam.common.grammar.Kategoria;
import pl.topteam.common.i18n.Liczebnik;

public final class Kwota {
    private static final String[] zl = new String[]{"z\u0142oty", "z\u0142ote", "z\u0142otych"};
    private static final String[] gr = new String[]{"grosz", "grosze", "groszy"};

    private Kwota() {
    }

    public static String slownie(long x) {
        Preconditions.checkArgument((x >= 0L ? 1 : 0) != 0, (String)"Liczba groszy musi by\u0107 nieujemna, przekazano: %s", (long)x);
        long _zl = x / 100L;
        long _gr = x % 100L;
        return Joiner.on((String)" ").join((Object)Kwota._slownie(_zl), (Object)zl[Kwota._wariant(_zl)], new Object[]{"i", Kwota._slownie(_gr), gr[Kwota._wariant(_gr)]});
    }

    public static String slownie(@NonNull BigDecimal x) {
        Preconditions.checkArgument((x.scale() == 2 ? 1 : 0) != 0, (String)"Liczba musi by\u0107 poprawn\u0105 kwot\u0105, przekazano: %s", (Object)x);
        return Kwota.slownie(x.movePointRight(2).longValueExact());
    }

    private static int _wariant(long x) {
        assert (x >= 0L);
        if (x <= 0L) {
            return 2;
        }
        if (x <= 1L) {
            return 0;
        }
        if (x <= 4L) {
            return 1;
        }
        if (x <= 19L) {
            return 2;
        }
        if (x % 10L <= 1L) {
            return 2;
        }
        if (x % 10L <= 4L) {
            return 1;
        }
        if (x % 10L <= 9L) {
            return 2;
        }
        throw new AssertionError();
    }

    private static String _slownie(long x) {
        return Liczebnik.glowny(x, new Kategoria[0]).replaceAll("(?U)\\b(?<liczebnik>tysi\u0105c|milion|miliard|bilion|biliard|trylion)\\b", "jeden ${liczebnik}");
    }
}

