/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.i18n;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.NavigableMap;
import pl.topteam.common.grammar.Kategoria;
import pl.topteam.common.grammar.Przypadek;
import pl.topteam.common.i18n.Deklinacja;
import pl.topteam.common.i18n.LiczebnikGlowny;
import pl.topteam.common.i18n.Liczebniki;

@Beta
final class LiczebnikZbiorowy {
    private static final NavigableMap<Long, String[]> DEKLINACJA = Deklinacja.wczytaj("LiczebnikZbiorowy.csv", Przypadek.class);

    private LiczebnikZbiorowy() {
    }

    private static String deklinacja(long x, Przypadek p) {
        return ((String[])DEKLINACJA.get(x))[p.ordinal()];
    }

    public static String slownie(long l, Kategoria ... k) {
        long[] liczebniki;
        Preconditions.checkArgument((l >= 2L ? 1 : 0) != 0, (String)"Liczba musi by\u0107 wi\u0119ksza lub r\u00f3wna 2, przekazano: %s", (long)l);
        Przypadek przypadek = (Przypadek)FluentIterable.from((Object[])k).filter(Przypadek.class).last().or((Object)Przypadek.MIANOWNIK);
        ArrayList<String> slowa = new ArrayList<String>();
        long r = l % 1000L;
        if (l >= 1000L) {
            slowa.add(LiczebnikGlowny.slownie(l - r, przypadek));
        }
        for (long liczebnik : liczebniki = Liczebniki.liczebniki(r).toArray()) {
            slowa.add(DEKLINACJA.containsKey(liczebnik) ? LiczebnikZbiorowy.deklinacja(liczebnik, przypadek) : LiczebnikGlowny.slownie(liczebnik, przypadek));
        }
        return Joiner.on((String)" ").join(slowa);
    }
}

