/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.xml;

import com.google.common.base.Preconditions;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.checkerframework.checker.nullness.qual.PolyNull;

abstract class TemporalAccessorAdapter<T extends TemporalAccessor>
extends XmlAdapter<String, T> {
    private final DateTimeFormatter format;
    private final TemporalQuery<T> query;

    TemporalAccessorAdapter(DateTimeFormatter format, TemporalQuery<T> query) {
        this.format = (DateTimeFormatter)Preconditions.checkNotNull((Object)format);
        this.query = (TemporalQuery)Preconditions.checkNotNull(query);
    }

    public final @PolyNull T unmarshal(@PolyNull String v) {
        return (T)(v == null ? null : (TemporalAccessor)this.format.parse((CharSequence)v, this.query));
    }

    public final @PolyNull String marshal(@PolyNull T v) {
        return v == null ? null : this.format.format((TemporalAccessor)v);
    }
}

