/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Immutable(containerOf={"N"})
@Beta
public final class Edge<N> {
    private final N parent;
    private final N child;

    public Edge(N parent, N child) {
        this.parent = Preconditions.checkNotNull(parent);
        this.child = Preconditions.checkNotNull(child);
    }

    public N parent() {
        return this.parent;
    }

    public N child() {
        return this.child;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Edge)) return false;
        Edge other = (Edge)object;
        if (!this.parent.equals(other.parent)) return false;
        if (!this.child.equals(other.child)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.child);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parent", this.parent).add("child", this.child).toString();
    }
}

