/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ExtraArrays {
    private ExtraArrays() {
    }

    public static <T> T first(T[] a) {
        Preconditions.checkArgument((a.length >= 1 ? 1 : 0) != 0, (Object)"Tablica musi zawiera\u0107 przynajmniej 1 element");
        assert (a.length >= 1) : "@AssumeAssertion(index)";
        return a[0];
    }

    public static <T> T[] first(T[] a, int n) {
        int l;
        Preconditions.checkNotNull(a);
        int n2 = l = n >= 0 ? Math.min(n, a.length) : Math.max(0, a.length + n);
        assert (l <= a.length) : "@AssumeAssertion(index)";
        return Arrays.copyOf(a, l);
    }

    public static <T> T last(T[] a) {
        Preconditions.checkArgument((a.length >= 1 ? 1 : 0) != 0, (Object)"Tablica musi zawiera\u0107 przynajmniej 1 element");
        assert (a.length >= 1) : "@AssumeAssertion(index)";
        return a[a.length - 1];
    }

    public static <T> T[] last(T[] a, int n) {
        int f;
        Preconditions.checkNotNull(a);
        int n2 = f = n >= 0 ? Math.max(0, a.length - n) : Math.min(-n, a.length);
        assert (f >= 0) : "@AssumeAssertion(index)";
        assert (f <= a.length) : "@AssumeAssertion(index)";
        return Arrays.copyOfRange(a, f, a.length);
    }
}

