/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Beta
public final class ExtraRangeMaps {
    private ExtraRangeMaps() {
    }

    public static <K extends Comparable<? super K>, V> ImmutableRangeMap<K, V> coalesced(ImmutableRangeMap<K, V> map) {
        Preconditions.checkNotNull(map);
        TreeRangeMap coalescedMap = TreeRangeMap.create();
        map.asMapOfRanges().forEach((arg_0, arg_1) -> ExtraRangeMaps.lambda$coalesced$0((RangeMap)coalescedMap, arg_0, arg_1));
        return ImmutableRangeMap.copyOf((RangeMap)coalescedMap);
    }

    public static <T, K extends Comparable<? super K>, V> Collector<T, ?, ImmutableRangeMap<K, V>> toImmutableRangeMap(Function<? super T, Range<K>> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> remappingFunction) {
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(remappingFunction);
        return Collector.of(TreeRangeMap::create, (map, input) -> map.merge((Range)keyFunction.apply(input), valueFunction.apply(input), (BiFunction)remappingFunction), (map, other) -> {
            other.asMapOfRanges().forEach((range, value) -> map.merge(range, value, (BiFunction)remappingFunction));
            return map;
        }, ImmutableRangeMap::copyOf, new Collector.Characteristics[0]);
    }

    private static /* synthetic */ void lambda$coalesced$0(RangeMap coalescedMap, Range range, Object value) {
        coalescedMap.putCoalescing(range, value);
    }
}

