/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import pl.topteam.common.collect.Edge;
import pl.topteam.common.collect.EdgeSet;
import pl.topteam.common.collect.Printer;
import pl.topteam.common.collect.Stringifier;

@NullMarked
@Immutable(containerOf={"N"})
public final class Tree<N> {
    private final ImmutableSet<N> nodes;
    private final ImmutableMap<N, N> parents;
    private final ImmutableSetMultimap<N, N> children;
    private final N root;

    private Tree(ImmutableSet<N> nodes, ImmutableMap<N, N> parents, ImmutableSetMultimap<N, N> children, N root) {
        this.nodes = (ImmutableSet)Preconditions.checkNotNull(nodes);
        this.parents = (ImmutableMap)Preconditions.checkNotNull(parents);
        this.children = (ImmutableSetMultimap)Preconditions.checkNotNull(children);
        this.root = Preconditions.checkNotNull(root);
    }

    public N root() {
        return this.root;
    }

    public Optional<N> parent(N node) {
        Preconditions.checkNotNull(node);
        Preconditions.checkArgument((boolean)this.nodes.contains(node));
        Object parent = this.parents.get(node);
        return Optional.ofNullable(parent);
    }

    public Set<N> children(N node) {
        Preconditions.checkNotNull(node);
        Preconditions.checkArgument((boolean)this.nodes.contains(node));
        return this.children.get(node);
    }

    public static <N> Builder<N> builder(N root) {
        return new Builder<N>(root);
    }

    @Beta
    public Set<N> nodes() {
        return this.nodes;
    }

    @Beta
    public Set<Edge<N>> edges() {
        return new EdgeSet<N>(this.parents);
    }

    @Beta
    public void print() throws IOException {
        Printer.forTree(this::children).print(this.root());
    }

    @Beta
    public void printTo(Appendable appendable) throws IOException {
        Preconditions.checkNotNull((Object)appendable);
        Printer.forTree(this::children).appendingTo(appendable).print(this.root());
    }

    public int hashCode() {
        return this.parents.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Tree)) return false;
        Tree other = (Tree)object;
        if (!this.nodes.equals(other.nodes)) return false;
        if (!this.parents.equals(other.parents)) return false;
        return true;
    }

    public String toString() {
        return Stringifier.forTree(this::children).stringify(this.root);
    }

    @NullMarked
    public static final class Builder<N> {
        private final ImmutableMap.Builder<N, N> parents = ImmutableMap.builder();
        private final ImmutableSetMultimap.Builder<N, N> children = ImmutableSetMultimap.builder();
        private final N root;
        private final Set<N> nodes = new LinkedHashSet<N>();

        private Builder(N root) {
            Preconditions.checkNotNull(root);
            this.nodes.add(root);
            this.root = root;
        }

        public Builder<N> add(N parent, N child) {
            Preconditions.checkNotNull(parent);
            Preconditions.checkNotNull(child);
            Preconditions.checkState((boolean)this.nodes.contains(parent));
            Preconditions.checkState((!this.nodes.contains(child) ? 1 : 0) != 0);
            this.parents.put(child, parent);
            this.children.put(parent, child);
            this.nodes.add(child);
            return this;
        }

        public Tree<N> build() {
            return new Tree<N>(ImmutableSet.copyOf(this.nodes), this.parents.build(), this.children.build(), this.root);
        }
    }
}

