/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.util;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jspecify.annotations.Nullable;

public final class LocalizedComparator
implements Comparator<String>,
Serializable {
    private final Collator collator;
    private final Locale locale;
    private final Strength strength;
    private final DecompositionMode decomposition;

    public LocalizedComparator(@NonNull Locale locale, @NonNull Strength strength, @NonNull DecompositionMode decomposition) {
        this.collator = LocalizedComparator.collator(locale, strength, decomposition);
        this.locale = locale;
        this.strength = strength;
        this.decomposition = decomposition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof LocalizedComparator)) return false;
        LocalizedComparator that = (LocalizedComparator)object;
        if (!Objects.equals(this.locale, that.locale)) return false;
        if (!Objects.equals((Object)this.strength, (Object)that.strength)) return false;
        if (!Objects.equals((Object)this.decomposition, (Object)that.decomposition)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.locale, this.strength, this.decomposition});
    }

    @Override
    public int compare(String s1, String s2) {
        return this.collator.compare(s1, s2);
    }

    Object writeReplace() {
        return new SerializedForm(this.locale, this.strength, this.decomposition);
    }

    private static Collator collator(Locale locale, Strength strength, DecompositionMode decomposition) {
        Collator collator = Collator.getInstance(locale);
        collator.setStrength(strength.ordinal());
        collator.setDecomposition(decomposition.ordinal());
        return collator;
    }

    public static enum Strength {
        PRIMARY,
        SECONDARY,
        TERTIARY,
        IDENTICAL;

    }

    public static enum DecompositionMode {
        NO_DECOMPOSITION,
        CANONICAL_DECOMPOSITION,
        FULL_DECOMPOSITION;

    }

    private static final class SerializedForm
    implements Serializable {
        final Locale locale;
        final Strength strength;
        final DecompositionMode decomposition;
        private static final long serialVersionUID = 0L;

        SerializedForm(Locale locale, Strength strength, DecompositionMode decomposition) {
            this.locale = locale;
            this.strength = strength;
            this.decomposition = decomposition;
        }

        Object readResolve() {
            return new LocalizedComparator(this.locale, this.strength, this.decomposition);
        }
    }
}

