/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import pl.topteam.common.util.LexicographicalComparator;

@NullMarked
public final class Index<V> {
    private final ImmutableList<String> keys;
    private final ImmutableList<V> values;
    private final Comparator<Character> comparator;
    private final Comparator<String> keyComparator;
    private final Comparator<String> lowerBoundKeyComparator;
    private final Comparator<String> upperBoundKeyComparator;
    private final Comparator<String> lowerBoundPrefixComparator;
    private final Comparator<String> upperBoundPrefixComparator;

    private Index(List<String> keys, List<V> values, Comparator<Character> comparator) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
        this.keyComparator = new LexicographicalComparator(comparator);
        this.lowerBoundKeyComparator = (string, key) -> this.keyComparator.compare((String)string, (String)key) >= 0 ? 1 : -1;
        this.upperBoundKeyComparator = (string, key) -> this.keyComparator.compare((String)string, (String)key) <= 0 ? -1 : 1;
        this.lowerBoundPrefixComparator = (string, prefix) -> {
            int length = Math.min(string.length(), prefix.length());
            String substring = string.substring(0, length);
            return this.lowerBoundKeyComparator.compare(substring, (String)prefix);
        };
        this.upperBoundPrefixComparator = (string, prefix) -> {
            int length = Math.min(string.length(), prefix.length());
            String substring = string.substring(0, length);
            return this.upperBoundKeyComparator.compare(substring, (String)prefix);
        };
        if (!Comparators.isInOrder(keys, this.keyComparator)) {
            List entries = (List)Streams.zip(keys.stream(), values.stream(), Maps::immutableEntry).sorted(Map.Entry.comparingByKey(this.keyComparator)).collect(ImmutableList.toImmutableList());
            this.keys = (ImmutableList)entries.stream().map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            this.values = (ImmutableList)entries.stream().map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        } else {
            this.keys = ImmutableList.copyOf(keys);
            this.values = ImmutableList.copyOf(values);
        }
    }

    public static <V> Builder<V> naturalOrder() {
        return new Builder(Comparator.naturalOrder());
    }

    public static <V> Builder<V> reverseOrder() {
        return new Builder(Comparator.reverseOrder());
    }

    public static <V> Builder<V> orderedBy(Comparator<Character> comparator) {
        return new Builder(comparator);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public Comparator<Character> comparator() {
        return this.comparator;
    }

    public boolean containsKey(String key) {
        return Collections.binarySearch(this.keys, key, this.keyComparator) >= 0;
    }

    public boolean containsPrefix(String prefix) {
        return this.lowerBoundPrefixIndex(prefix) < this.upperBoundPrefixIndex(prefix);
    }

    public boolean containsValue(V value) {
        return this.values.contains(value);
    }

    public SortedMultiset<String> keys() {
        return this.keys(0, this.keys.size());
    }

    public SortedMultiset<String> keys(String prefix) {
        return this.keys(this.lowerBoundPrefixIndex(prefix), this.upperBoundPrefixIndex(prefix));
    }

    public SortedSet<String> keySet() {
        return this.keySet(0, this.keys.size());
    }

    public SortedSet<String> keySet(String prefix) {
        return this.keySet(this.lowerBoundPrefixIndex(prefix), this.upperBoundPrefixIndex(prefix));
    }

    public List<V> values() {
        return this.values;
    }

    public Iterable<Map.Entry<String, V>> entries() {
        return this.entries(0, this.keys.size());
    }

    public Iterable<Map.Entry<String, V>> entries(String prefix) {
        return this.entries(this.lowerBoundPrefixIndex(prefix), this.upperBoundPrefixIndex(prefix));
    }

    public Iterable<Map.Entry<String, Set<V>>> entrySet() {
        return this.entrySet(0, this.keys.size());
    }

    public Iterable<Map.Entry<String, Set<V>>> entrySet(String prefix) {
        return this.entrySet(this.lowerBoundPrefixIndex(prefix), this.upperBoundPrefixIndex(prefix));
    }

    public Set<V> get(String key) {
        return ImmutableSet.copyOf((Collection)this.values.subList(this.lowerBoundKeyIndex(key), this.upperBoundKeyIndex(key)));
    }

    private SortedMultiset<String> keys(int from, int to) {
        return ImmutableSortedMultiset.copyOf(this.keyComparator, (Iterable)this.keys.subList(from, to));
    }

    private SortedSet<String> keySet(int from, int to) {
        return ImmutableSortedSet.copyOf(this.keyComparator, (Collection)this.keys.subList(from, to));
    }

    private Iterable<Map.Entry<String, V>> entries(final int from, final int to) {
        return () -> new AbstractIterator<Map.Entry<String, V>>(this){
            private int i;
            final /* synthetic */ Index this$0;
            {
                Index index = this$0;
                Objects.requireNonNull(index);
                this.this$0 = index;
                this.i = from;
            }

            protected  @Nullable Map.Entry<String, V> computeNext() {
                return this.i < to ? Maps.immutableEntry((Object)((String)this.this$0.keys.get(this.i)), (Object)this.this$0.values.get(this.i++)) : (Map.Entry)this.endOfData();
            }
        };
    }

    private Iterable<Map.Entry<String, Set<V>>> entrySet(final int from, final int to) {
        return () -> new AbstractIterator<Map.Entry<String, Set<V>>>(this){
            private int i;
            final /* synthetic */ Index this$0;
            {
                Index index = this$0;
                Objects.requireNonNull(index);
                this.this$0 = index;
                this.i = from;
            }

            public  @Nullable Map.Entry<String, Set<V>> computeNext() {
                Map.Entry entry;
                if (this.i < to) {
                    this.i = this.this$0.upperBoundKeyIndex((String)this.this$0.keys.get(this.i));
                    entry = Maps.immutableEntry((Object)((String)this.this$0.keys.get(this.i)), (Object)ImmutableSet.copyOf((Collection)this.this$0.values.subList(this.i, this.i)));
                } else {
                    entry = (Map.Entry)this.endOfData();
                }
                return entry;
            }
        };
    }

    private int lowerBoundKeyIndex(String key) {
        return ~Collections.binarySearch(this.keys, key, this.lowerBoundKeyComparator);
    }

    private int upperBoundKeyIndex(String key) {
        return ~Collections.binarySearch(this.keys, key, this.upperBoundKeyComparator);
    }

    private int lowerBoundPrefixIndex(String prefix) {
        return ~Collections.binarySearch(this.keys, prefix, this.lowerBoundPrefixComparator);
    }

    private int upperBoundPrefixIndex(String prefix) {
        return ~Collections.binarySearch(this.keys, prefix, this.upperBoundPrefixComparator);
    }

    @NullMarked
    public static final class Builder<V> {
        private final ImmutableList.Builder<String> keys = ImmutableList.builder();
        private final ImmutableList.Builder<V> values = ImmutableList.builder();
        private final Comparator<Character> comparator;

        private Builder(Comparator<Character> comparator) {
            this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
        }

        public Builder<V> put(String key, V value) {
            this.keys.add((Object)key);
            this.values.add(value);
            return this;
        }

        public Index<V> build() {
            return new Index((List<String>)this.keys.build(), this.values.build(), this.comparator);
        }
    }
}

