/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ExtraInts {
    private ExtraInts() {
    }

    @Beta
    public static @Nullable Integer tryParseNullable(@Nullable String string) {
        return string == null ? null : Ints.tryParse((String)string);
    }

    @Beta
    public static @Nullable Integer tryParseNullable(@Nullable String string, int radix) {
        return string == null ? null : Ints.tryParse((String)string, (int)radix);
    }

    public static int first(int[] x) {
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (Object)"Tablica musi zawiera\u0107 przynajmniej 1 element");
        assert (x.length >= 1) : "@AssumeAssertion(index)";
        return x[0];
    }

    public static int[] first(int[] x, int n) {
        Preconditions.checkNotNull((Object)x);
        return n >= 0 ? Arrays.copyOf(x, Math.min(n, x.length)) : Arrays.copyOf(x, Math.max(0, x.length + n));
    }

    public static int last(int[] x) {
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (Object)"Tablica musi zawiera\u0107 przynajmniej 1 element");
        assert (x.length >= 1) : "@AssumeAssertion(index)";
        return x[x.length - 1];
    }

    public static int[] last(int[] x, int n) {
        Preconditions.checkNotNull((Object)x);
        return n >= 0 ? Arrays.copyOfRange(x, Math.max(0, x.length - n), x.length) : Arrays.copyOfRange(x, Math.min(-n, x.length), x.length);
    }

    public static int product(int[] x, int[] y) {
        int length = ExtraInts.checkEqual(x.length, y.length, "Tablice musz\u0105 by\u0107 tej samej d\u0142ugo\u015bci");
        return IntStream.range(0, length).map(i -> Math.multiplyExact(x[i], y[i])).reduce(0, Math::addExact);
    }

    public static int sum(int[] x) {
        Preconditions.checkNotNull((Object)x);
        return IntStream.of(x).reduce(0, Math::addExact);
    }

    private static int checkEqual(int x, int y, String errorMessage) {
        if (x != y) {
            throw new IllegalArgumentException(errorMessage);
        }
        return x;
    }
}

