/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class AlphanumericComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final CharMatcher zeroes = CharMatcher.is((char)'0');
    private static final CharMatcher digits = CharMatcher.inRange((char)'0', (char)'9');
    private static final CharMatcher chars = digits.negate();
    private static final Comparator<String> dcomparator = Comparator.comparing(arg_0 -> ((CharMatcher)zeroes).trimLeadingFrom(arg_0), Comparator.comparingInt(String::length).thenComparing(Comparator.naturalOrder()));
    private final Comparator<? super String> comparator;

    public AlphanumericComparator() {
        this.comparator = Comparator.naturalOrder();
    }

    public AlphanumericComparator(Comparator<? super String> comparator) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof AlphanumericComparator)) return false;
        AlphanumericComparator that = (AlphanumericComparator)object;
        if (!Objects.equals(this.comparator, that.comparator)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.comparator);
    }

    @Override
    public int compare(String s1, String s2) {
        String _s1 = s1;
        String _s2 = s2;
        while (!_s1.isEmpty() && !_s2.isEmpty()) {
            int d1 = digits.indexIn((CharSequence)_s1);
            int d2 = digits.indexIn((CharSequence)_s2);
            int c1 = chars.indexIn((CharSequence)_s1);
            int c2 = chars.indexIn((CharSequence)_s2);
            int _d1 = d1 >= 0 ? d1 : _s1.length();
            int _c1 = c1 >= 0 ? c1 : _s1.length();
            int _d2 = d2 >= 0 ? d2 : _s2.length();
            int _c2 = c2 >= 0 ? c2 : _s2.length();
            int i1 = Math.max(_d1, _c1);
            int i2 = Math.max(_d2, _c2);
            Comparator<? super String> c = _d1 != 0 || _d2 != 0 ? this.comparator : dcomparator;
            int r = c.compare(_s1.substring(0, i1), _s2.substring(0, i2));
            if (r != 0) {
                return r;
            }
            assert (i1 <= _s1.length()) : "@AssumeAssertion(index)";
            assert (i2 <= _s2.length()) : "@AssumeAssertion(index)";
            _s1 = _s1.substring(i1);
            _s2 = _s2.substring(i2);
        }
        return Integer.compare(_s1.length(), _s2.length());
    }
}

