/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.util;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jspecify.annotations.Nullable;

public final class LexicographicalComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<? super Character> comparator;

    public LexicographicalComparator(@NonNull Comparator<? super Character> comparator) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof LexicographicalComparator)) return false;
        LexicographicalComparator that = (LexicographicalComparator)object;
        if (!Objects.equals(this.comparator, that.comparator)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.comparator);
    }

    @Override
    public int compare(String s1, String s2) {
        int minLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < minLength; ++i) {
            int result = this.comparator.compare(Character.valueOf(s1.charAt(i)), Character.valueOf(s2.charAt(i)));
            if (result == 0) continue;
            return result;
        }
        return s1.length() - s2.length();
    }
}

