/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.SortedSet;

public final class KalkulatorNominalow {
    public static final NavigableSet<BigDecimal> NOMINALY = ImmutableSortedSet.of((Comparable)new BigDecimal("0.01"), (Comparable)new BigDecimal("0.02"), (Comparable)new BigDecimal("0.05"), (Comparable)new BigDecimal("0.10"), (Comparable)new BigDecimal("0.20"), (Comparable)new BigDecimal("0.50"), (Comparable[])new BigDecimal[]{new BigDecimal("1.00"), new BigDecimal("2.00"), new BigDecimal("5.00"), new BigDecimal("10.00"), new BigDecimal("20.00"), new BigDecimal("50.00"), new BigDecimal("100.00"), new BigDecimal("200.00"), new BigDecimal("500.00")});

    private KalkulatorNominalow() {
    }

    public static SortedMultiset<BigDecimal> nominaly(BigDecimal kwota) {
        return KalkulatorNominalow.nominaly(kwota, NOMINALY);
    }

    public static SortedMultiset<BigDecimal> nominaly(BigDecimal kwota, SortedSet<BigDecimal> nominaly) {
        return KalkulatorNominalow.nominaly(kwota, (SortedMultiset<BigDecimal>)((SortedMultiset)nominaly.stream().collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder(), e -> e, e -> Integer.MAX_VALUE))));
    }

    public static SortedMultiset<BigDecimal> nominaly(BigDecimal kwota, SortedMultiset<BigDecimal> nominaly) {
        Preconditions.checkArgument((kwota.signum() >= 0 ? 1 : 0) != 0, (String)"Kwota musi by\u0107 nieujemna, przekazano: %s", (Object)kwota);
        TreeMultiset _NOMINALY = TreeMultiset.create(nominaly);
        TreeMultiset _nominaly = TreeMultiset.create();
        while (kwota.signum() > 0) {
            BigDecimal nominal = _NOMINALY.elementSet().floor(kwota);
            Preconditions.checkArgument((nominal != null ? 1 : 0) != 0, (Object)"Nie mo\u017cna zach\u0142annie wyda\u0107 kwoty z u\u017cyciem zadanych nomina\u0142\u00f3w: brak wystarczaj\u0105co ma\u0142ego nomina\u0142u");
            assert (nominal != null) : "@AssumeAssertion(nullness): Nomina\u0142 nie mo\u017ce by\u0107 nullem ze wzgl\u0119du na sprawdzenie powy\u017cej";
            Preconditions.checkArgument((nominal.signum() > 0 ? 1 : 0) != 0, (Object)"Nie mo\u017cna zach\u0142annie wyda\u0107 kwoty z u\u017cyciem zadanych nomina\u0142\u00f3w: jeden z nomina\u0142\u00f3w jest ujemny lub zerowy");
            BigDecimal potrzebne = kwota.divideToIntegralValue(nominal);
            BigDecimal dostepne = BigDecimal.valueOf(_NOMINALY.count((Object)nominal));
            BigDecimal uzyte = potrzebne.min(dostepne);
            _NOMINALY.remove((Object)nominal, uzyte.intValueExact());
            _nominaly.add((Object)nominal, uzyte.intValueExact());
            kwota = kwota.subtract(uzyte.multiply(nominal));
        }
        return _nominaly;
    }
}

