/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.calc;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.Immutable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.checkerframework.common.value.qual.ArrayLen;

@Immutable
@Beta
public final class KalkulatorPodzialuLiczbCalkowitych {
    private final ImmutableList<BigInteger> proporcje;
    private final BigInteger suma;

    public KalkulatorPodzialuLiczbCalkowitych(List<BigInteger> proporcje) {
        Preconditions.checkNotNull(proporcje);
        for (BigInteger proporcja : proporcje) {
            Preconditions.checkNotNull((Object)proporcja);
            Preconditions.checkArgument((proporcja.signum() >= 0 ? 1 : 0) != 0);
        }
        this.proporcje = KalkulatorPodzialuLiczbCalkowitych.kopia(proporcje);
        this.suma = KalkulatorPodzialuLiczbCalkowitych.suma(proporcje);
        Preconditions.checkArgument((this.suma.signum() > 0 ? 1 : 0) != 0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<BigInteger> podzial(BigInteger liczba) {
        Preconditions.checkNotNull((Object)liczba);
        Preconditions.checkArgument((liczba.signum() >= 0 ? 1 : 0) != 0);
        @ArrayLen(value={2}) List skladniki = (List)this.proporcje.stream().map(proporcja -> liczba.multiply((BigInteger)proporcja).divideAndRemainder(this.suma)).collect(ImmutableList.toImmutableList());
        int sumarycznyBlad = liczba.subtract(skladniki.stream().map(this::iloraz).reduce(BigInteger.ZERO, BigInteger::add)).intValueExact();
        Comparator<BigInteger @ArrayLen(value={2}) []> komparatorReszt = Comparator.comparing(this::reszta).thenComparing(Ordering.explicit((List)skladniki).reversed());
        @ArrayLen(value={2}) ImmutableSet skladnikiONajwiekszychResztach = ImmutableSet.copyOf((Collection)((Collection)skladniki.stream().collect(Comparators.greatest((int)sumarycznyBlad, komparatorReszt))));
        return (List)skladniki.stream().map(arg_0 -> this.lambda$podzial$1((Set)skladnikiONajwiekszychResztach, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private BigInteger iloraz(BigInteger @ArrayLen(value={2}) [] wynik) {
        return wynik[0];
    }

    private BigInteger reszta(BigInteger @ArrayLen(value={2}) [] wynik) {
        return wynik[1];
    }

    private static ImmutableList<BigInteger> kopia(List<BigInteger> proporcje) {
        return ImmutableList.copyOf(proporcje);
    }

    private static BigInteger suma(List<BigInteger> proporcje) {
        return proporcje.stream().reduce(BigInteger.ZERO, BigInteger::add);
    }

    private /* synthetic */ BigInteger lambda$podzial$1(Set skladnikiONajwiekszychResztach, BigInteger[] skladnik) {
        return this.iloraz(skladnik).add(skladnikiONajwiekszychResztach.contains(skladnik) ? BigInteger.ONE : BigInteger.ZERO);
    }
}

