/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.calc;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Immutable
@Beta
public final class KalkulatorZaokraglen {
    private final BigDecimal rozdzielczosc;
    private final RoundingMode tryb;

    public KalkulatorZaokraglen(BigDecimal rozdzielczosc, RoundingMode tryb) {
        Preconditions.checkNotNull((Object)rozdzielczosc);
        Preconditions.checkNotNull((Object)((Object)tryb));
        Preconditions.checkArgument((rozdzielczosc.signum() > 0 ? 1 : 0) != 0);
        this.rozdzielczosc = rozdzielczosc;
        this.tryb = tryb;
    }

    public BigDecimal zaokraglenie(BigDecimal liczba) {
        Preconditions.checkNotNull((Object)liczba);
        return liczba.divide(this.rozdzielczosc, 0, this.tryb).multiply(this.rozdzielczosc);
    }
}

