/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.NavigableMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ExtraMaps {
    private ExtraMaps() {
    }

    public static <K extends Comparable<? super K>, V> ImmutableRangeMap<K, V> toImmutableRangeMap(@NonNull NavigableMap<K, V> map) {
        Preconditions.checkNotNull(map);
        TreeRangeMap rangeMap = TreeRangeMap.create();
        map.forEach((key, value) -> rangeMap.put(Range.atLeast((Comparable)key), value));
        return ImmutableRangeMap.copyOf((RangeMap)rangeMap);
    }
}

