/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.stream.LongStream;
import java.util.stream.Stream;

@Beta
public final class ExtraStreams {
    private ExtraStreams() {
    }

    public static <T> void forEachWithIndex(Stream<T> stream, ConsumerWithIndex<T> consumer) {
        Preconditions.checkNotNull(consumer);
        if (stream.isParallel()) {
            Streams.forEachPair(stream, LongStream.rangeClosed(0L, Long.MAX_VALUE).boxed(), (value, index) -> consumer.accept(value, (long)index));
        } else {
            long index2 = 0L;
            Iterator iter = stream.iterator();
            while (iter.hasNext()) {
                consumer.accept(iter.next(), index2++);
            }
        }
    }

    public static interface ConsumerWithIndex<T> {
        public void accept(T var1, long var2);
    }
}

